<?php

namespace App\Classes\Sales;

use DB;
use DateTime;
class DeptAgeReportHelper
{
    public static function debt_age_report($lang, $params)
    {
        $from   = $params['from'];
        $to     = $params['to'];
        // $query = DB::table('sales_invoice_m')
        //     ->leftJoin('customers','sales_invoice_m.customer_id','customers.customer_id')
        //     ->where('sales_invoice_m.sales_invoice_type_id', 1)
        //     ->groupBy('sales_invoice_m.sales_invoice_m_id')
        //     ->orderBy('customers.customer_id')
        //     ->selectRaw(
        //         'sales_invoice_m.sales_invoice_m_id,
        //         sales_invoice_m.sales_invoice_date,
        //         customers.name_'.$lang .' as customer_name,
        //         customers.term_period,
        //         sales_invoice_m.total_with_vat,
        //         sales_invoice_m.total_with_vat  / 2 as amount_permonth,
        //         sum( case when sales_invoice_m.sales_invoice_date < "'.date("Y-m-d").'" and sales_invoice_m.sales_invoice_date > "'.date("Y-m-d" , strtotime("-1 month")).'" then total_with_vat end ) as from0to30,
        //         sum( case when sales_invoice_m.sales_invoice_date < "'.date("Y-m-d" , strtotime("+1 month")).'" and sales_invoice_m.sales_invoice_date > "'.date("Y-m-d").'" then total_with_vat end ) as from30to60,
        //         sum( case when sales_invoice_m.sales_invoice_date < "'.date("Y-m-d" , strtotime("+2 month")).'" and sales_invoice_m.sales_invoice_date > "'.date("Y-m-d" , strtotime("+1 month")).'" then total_with_vat end ) as from60to90,
        //         sum( case when sales_invoice_m.sales_invoice_date < "'.date("Y-m-d" , strtotime("+3 month")).'" and sales_invoice_m.sales_invoice_date > "'.date("Y-m-d" , strtotime("+2 month")).'" then total_with_vat end ) as from90to120
        //     ');
            $query = DB::table('sales_invoice_m')
            ->leftJoin('customers', 'sales_invoice_m.customer_id', 'customers.customer_id')
            ->where('sales_invoice_m.sales_invoice_type_id', 1)
            ->groupBy('sales_invoice_m.sales_invoice_m_id')
            ->orderBy('customers.customer_id')
            ->selectRaw("
                sales_invoice_m.sales_invoice_m_id,
                sales_invoice_m.sales_invoice_date,
                customers.name_{$lang} as customer_name,
                customers.term_period,
                sales_invoice_m.total_with_vat,
                sales_invoice_m.total_with_vat / 2 as amount_permonth,
                sum(case when sales_invoice_m.sales_invoice_date < '{$to}' and sales_invoice_m.sales_invoice_date > '{$from}' then total_with_vat end) as from0to30,
                sum(case when sales_invoice_m.sales_invoice_date < DATE_ADD('{$to}', INTERVAL 1 MONTH) and sales_invoice_m.sales_invoice_date > '{$to}' then total_with_vat end) as from30to60,
                sum(case when sales_invoice_m.sales_invoice_date < DATE_ADD('{$to}', INTERVAL 2 MONTH) and sales_invoice_m.sales_invoice_date > DATE_ADD('{$to}', INTERVAL 1 MONTH) then total_with_vat end) as from60to90,
                sum(case when sales_invoice_m.sales_invoice_date < DATE_ADD('{$to}', INTERVAL 3 MONTH) and sales_invoice_m.sales_invoice_date > DATE_ADD('{$to}', INTERVAL 2 MONTH) then total_with_vat end) as from90to120
            ");

            return  $query->get();

    }
}

?>
