<?php

namespace App\Classes\Sales;
use App\Models\Sales\SalesInvoice;
use App\Models\Main\Setting;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Finance\DailyJournal;
use App\Models\Main\Branch;


use DB;
use Http;
use SimpleXMLElement;


class SalesInvoiceHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('sales_invoice_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('sales_invoice_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('sales_invoice_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function prepare_details($m_id , $proforma_invoice_id , $delivery_notes  , $items , $price_include_vat , $stock_watch = 0){

        if($proforma_invoice_id > 0 ){

            $rows = DB::table('proforma_invoice_d')
                ->where('proforma_invoice_m_id' , $proforma_invoice_id )
                ->selectRaw('proforma_invoice_d_id , tax_percent_id , vat_per , unit_id , item_id , warehouse_id , quantity , price , item_price , total_price , currency_id , foreign_currency , equivalent_value ,item_discount , total_discount , unit_type , discount , discount_per , total_without_vat , total_with_vat , total_vat , width , height , area_width , area_height , area_quantity , description')
                ->get();

        }elseif(count($delivery_notes) > 0 ){

            $rows = DB::table('delivery_note_d')
                ->whereIn('delivery_note_m_id' , $delivery_notes )
                ->selectRaw('delivery_note_d_id , tax_percent_id , vat_per , unit_id , item_id , warehouse_id , quantity , price , item_price , total_price , currency_id , foreign_currency , equivalent_value , item_discount , total_discount , unit_type , discount , discount_per , total_without_vat , total_with_vat , total_vat , width , height , area_width , area_height , area_quantity , description')
                ->get();

        }else{
            
            $rows   = ( new SalesGeneralHelper )->generate_items( $items , $price_include_vat  , $stock_watch );
            
        }
        

        $return = [] ;

        foreach ($rows as $key => $row){

            $row                                    = (array) $row;
            $return[$key]                           = $row;
            $return[$key]['sales_invoice_m_id']     = $m_id ;
            $return[$key]['add_user']               = auth()->user()->id;
            $return[$key]['detail_type']            = 1 ;

            $return[$key]['width']                  = $items[$key]['width'] ?? 0 ;
            $return[$key]['height']                 = $items[$key]['height'] ?? 0 ;
            $return[$key]['area_width']             = $items[$key]['area_width'] ?? 0 ;
            $return[$key]['area_height']            = $items[$key]['area_height'] ?? 0 ;
            $return[$key]['area_quantity']          = $items[$key]['area_quantity'] ?? 0 ;
            $return[$key]['description']            = $items[$key]['description'] ?? '' ;

            $return[$key]['currency_id']            = $row['currency_id'] ;
            $return[$key]['foreign_currency']       = $row['foreign_currency'] ;
            $return[$key]['equivalent_value']       = $row['equivalent_value'] ;

            $return[$key]['current_quantity']       = $row['quantity'] ;
            $return[$key]['current_price']          = $row['price'] ;
            $return[$key]['current_total_price']    = $row['total_price'] ;
            $return[$key]['current_total_vat']      = $row['total_vat'] ;
            $return[$key]['current_total_with_vat'] = $row['total_with_vat'] ;
            $return[$key]['current_total_without_vat']  = $row['total_without_vat'] ;

            $return[$key]['total_price_after_discount']         = ( $row['total_price']  - $row['total_discount'] );
            $return[$key]['item_price_after_discount']          = ( $row['item_price']  - $row['item_discount'] );
            $return[$key]['current_total_price_after_discount'] = $row['total_with_vat'];

            // $return[$key]['delivered_quantity']     = doubleval( $row['delivered_quantity'] ?? 0 );
        }
        return $return;
    }
    function prepare_update_details($m_id  , $items , $price_include_vat , $stock_watch = 0){


        $rows   = ( new SalesGeneralHelper )->generate_update_items( $items , $price_include_vat  , $stock_watch );

        $return = [] ;

        foreach ($rows as $key => $row){
            $row                                    = (array) $row;
            $return[$key]                           = $row;
            $return[$key]['sales_invoice_m_id']     = $m_id ;
            $return[$key]['add_user']               = auth()->user()->id;
            $return[$key]['detail_type']            = 1 ;

            $return[$key]['d_id']                   = $items[$key]['d_id'] ?? 0 ;
            $return[$key]['width']                  = $items[$key]['width'] ?? 0 ;
            $return[$key]['height']                 = $items[$key]['height'] ?? 0 ;
            $return[$key]['area_width']             = $items[$key]['area_width'] ?? 0 ;
            $return[$key]['area_height']            = $items[$key]['area_height'] ?? 0 ;
            $return[$key]['area_quantity']          = $items[$key]['area_quantity'] ?? 0 ;
            $return[$key]['description']            = $items[$key]['description'] ?? '' ;

            $return[$key]['current_quantity']       = $row['quantity'] ;
            $return[$key]['current_price']          = $row['price'] ;
            $return[$key]['current_total_price']    = $row['total_price'] ;
            $return[$key]['current_total_vat']      = $row['total_vat'] ;
            $return[$key]['current_total_with_vat'] = $row['total_with_vat'] ;
            $return[$key]['current_total_without_vat']  = $row['total_without_vat'] ;

            $return[$key]['total_price_after_discount']         = ( $row['total_price']  - $row['total_discount'] );
            $return[$key]['item_price_after_discount']          = ( $row['item_price']  - $row['item_discount'] );
            $return[$key]['current_total_price_after_discount'] = $row['total_with_vat'];
        }
        return $return;
    }

    function generate_daily_journal($id){


        $check = Setting::get_main_setting_by_code('sales_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $main       = SalesInvoice::get_sales_invoice_m( $id ,'en' );
        $details    = SalesInvoice::get_sales_invoice_d( $id ,'en' );
        $payments   = SalesInvoice::get_payments( $id ,'en' );

        if(!isset($main->sales_invoice_active) || $main->sales_invoice_active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_m_id);
            return array( true ,  '' ) ;
        }


        $items      = [];
        $journal_data  = array(
            'finance_year_id'   => $main->finance_year_id  ,
            'branch_id'         => $main->branch_id ,
            'des'               => $main->sales_invoice_description ,
            'journal_date'      => $main->sales_invoice_date ,
            'document_id'       => $id ,
            'daily_type_id'     => ($main->sales_invoice_type_id == 1) ? 13 : 12 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($main->daily_journal_m_id > 0 ){
            $journal_data['daily_journal_id'] = $main->daily_journal_m_id;
        }

        $items[]   = array(
            'account_tree_id'   => $main->customer_account_tree_id ,
            'cost_center_id'    => 0 ,
            'debit'             => $main->total_with_vat   ,
            'credit'            =>  0 ,
            'description'       => $main->sales_invoice_description
        );

        foreach ( $details as $key => $detail ) {

            if($detail->discount > 0 ){
                $items[]    = array(
                    'account_tree_id'       => $detail->sales_discount_id,
                    'cost_center_id'        => 0 ,
                    'debit'                 => $detail->discount   ,
                    'credit'                => 0 ,
                    'description'           => $main->sales_invoice_description
                );
            }

            $items[]    = array(
                'account_tree_id'   => $detail->sales_revenue_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'debit'             => 0  ,
                // 'credit'            => $detail->total_without_vat  ,
                'credit'            => $detail->total_without_vat,
                'description'       => $main->sales_invoice_description
            );

            if($detail->total_vat > 0 ){
                $items[]    = array(
                    'account_tree_id'   => $detail->tax_account_tree_id ?? 0 ,
                    'cost_center_id'    => 0 ,
                    'debit'             => 0 ,
                    'credit'            => $detail->total_vat ,
                    // 'credit'            => ( $detail->price * $detail->quantity ) * ( $detail->tax_percent / 100 ) ,
                    'description'       => $main->sales_invoice_description
                );
            }

        }
        if($main->sales_invoice_type_id > 1 ){
            foreach ( $payments as $key => $row ) {

                $items[]    = array(
                    'account_tree_id'   => $main->customer_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => 0  ,
                    'credit'            => $row->amount,
                    'description'       => $main->sales_invoice_description
                );

                if($row->payment_type == 1){
                    $account_tree_id = $row->treasury_account_tree_id ?? $main->branch_treasury_account_id;
                }else{
                    $account_tree_id = $row->machine_account_tree_id;
                }

                $items[]    = array(
                    'account_tree_id'   => $account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => $row->amount ,
                    'credit'            => 0 ,
                    'description'       => $main->sales_invoice_description
                );

            }
        }

        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items);

        if($journal[0]){

            DB::table('sales_invoice_m')
                ->where('sales_invoice_m_id' , $id)
                ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }


    }

    function update_master_values($id)
    {
        $master     = DB::table('sales_invoice_m')->where('sales_invoice_m_id', $id)->first();
        $details    = DB::table('sales_invoice_d')->where('sales_invoice_m_id', $id)->get();

        DB::table('sales_invoice_m')
            ->where('sales_invoice_m.sales_invoice_m_id', $id)
            ->update([
                'total_discount'                    => $details->sum('total_discount') ,
                'total_vat'                         => $details->sum('total_vat') ,
                'total_without_vat'                 => $details->sum('total_without_vat') ,
                'total_with_vat'                    => $details->sum('total_with_vat') ,
                'total_price_after_discount'        => $details->sum('total_without_vat') ,
                'total_without_vat_after_discount'  => $details->sum('total_without_vat')
            ]);

    }

    function send_zatca($invoice)
    {
        $data = check_third_app('zatca_integration');
        if (!$data['check'])
            return false;
        $data['app_data'] = json_decode($data['app_data'] , true);
        $last = SalesInvoice::get_sales_invoice_m(($invoice - 1), 'en');
        $master = SalesInvoice::get_sales_invoice_m($invoice, 'en');


        if(strlen($master->invoice_hash ) > 10){
            return true;
        }

        
        $details = SalesInvoice::get_sales_invoice_d($invoice, 'en');
        $branch = Branch::get_branch($master->branch_id, 'en');
        $last_hash = (!isset($last->invoice_hash) || strlen($last->invoice_hash) < 10 ? "NWZlY2ViNjZmZmM4NmYzOGQ5NTI3ODZjNmQ2OTZjNzljMmRiYzIzOWRkNGU5MWI0NjcyOWQ3M2EyN2ZiNTdlOQ==" : $last->invoice_hash);
        $invoice_type = (!isset($last->invoice_hash) || $last->sales_invoice_type_id == 1 ? "0100000" : "0200000");
        $token = $data['app_data'][$data['env']]['token'] ?? '';
        $header = [
            "Accept" => "application/json",
            "Content-Type" => "application/json",
            "Token" => $token
        ];
        
        $total_with_vat = round($master->total_with_vat,2);
        $total_vat      = round($master->total_vat,2);
        $total_without_vat = $total_with_vat - $total_vat;
        $body = [
            "id" => $invoice,
            "currency" => "SAR",
            "invoice_date" => $master->sales_invoice_date,
            "invoice_time" => date("H:i:s", strtotime($master->add_date)),
            "uuid" => $master->invoice_uuid,
            "invoice_type_code" => "388",
            "invoice_type_code_name" => $invoice_type,
            "pih" => $last_hash,
            "reference_id" => 0,
            "return_reson" => "reson",
            "totals" => [
                'total_vat' => $total_vat ,
                'total_without_vat' => $total_without_vat ,
                'total_with_vat' => $total_with_vat ,
                'discount' => 0,
                'total_taxble' => round(collect($details)->where('total_vat', '>', 0)->sum('total_without_vat'),2),
                'percent' => "15.00"
            ],
            "supplier_info" => [
                "crn" => $branch->crn,
                "vat_number" => $branch->vat_number,
                "vat_register_name" => $branch->vat_register_name,
                "address" => [
                    "streetName" => "RIYADH",
                    "buildingNumber" => "2322",
                    "plotIdentification" => "2223",
                    "citySubdivisionName" => "RIYADH",
                    "cityName" => "RIYADH",
                    "postalZone" => "11633",
                    "countrySubentity" => "Test",
                    "country" => "SA"
                ]
            ],
            "customerInfo" => [
                "nat" => "2345",
                "vat_number" => $master->vat_register_number,
                "vat_register_name" => $master->customer_name,
                "address" => [
                    "streetName" => $master->address,
                    "buildingNumber" => "3353",
                    "plotIdentification" => "1234",
                    "citySubdivisionName" => "R",
                    "cityName" => "Dammam",
                    "postalZone" => "12345",
                    "countrySubentity" => "Test",
                    "country" => "SA"
                ]
            ],
            "invoiceLineItem" => [],
        ];


        foreach ($details as $key => $row) {

            $body['invoiceLineItem'][] = [
                "id" => (string)$row->d_id,
                "qty" => $row->quantity,
                "name" => (empty($row->description) ? $row->item_name : $row->description),
                "total_vat" => round($row->total_vat , 2 ),
                "total_without_vat" => round($row->total_without_vat , 2 ),
                "total_with_vat" => round($row->total_with_vat , 2 ),
                "tax_code" => $row->zatca_code,
                "tax_scheme" => "VAT",
                "tax_percent" => $row->tax_percent
            ];
        }
        
        $result = Http::withHeaders($header)->post("https://sallawebhook.qaraterp.com/api/v1/send_invoice", $body);
        $result = json_decode($result->body() , true);



        if(isset($result['success']) &&  $result['success']){

            DB::table('sales_invoice_m')
                ->where('sales_invoice_m_id' , $invoice)
                ->update([
                    'invoice_hash'  => $result['hash'] ,
                    'invoice_qrcode'=> $result['qr']
                ]);

        }else{
            $response = [
                'check' => false,
                'data'  => $result ,
                'body'  => $body ,
                'msg'   => 'error in zatca'
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();
        }


        return true;
    }

}
