<?php
use App\Models\User;
use App\Models\main_data\MainSetting;

function check_third_app($app_code){
    $data = DB::table('third_party_apps')
        ->where('app_code' , $app_code )
        ->where('is_installed' , 1)
        ->first();
    if( !isset($data->is_installed) ){
        $return = ['check' => false  ];
    }else{
    $return = ['check' => true , 'env' => $data->app_env , 'app_data' => $data->app_data];

    }
    return $return;
}

function get_logo($id)
{
    $branch = DB::table('branchs')
        ->where('branch_id' , $id)
        ->first();

    if(isset($branch->branch_image) && $branch->branch_image != '' && $branch->branch_image != null){
        return $branch->branch_image;
    }
    return '';

    return MainSetting::get_main_setting_by_code('logo')->value;
}


function fix_number($val , $type)
{
    switch ($type) {
        case '1':
            return number_format(abs($val) , 2 , '.' , ',');
            break;
        case '2':
            if($val < 0 ){
                return "( ". number_format(abs($val) , 2 , '.' , ',')." )";
            }else{
                return number_format(abs($val) , 2 , '.' , ',');
            }
            break;
    }
}

function get_daily_journal_next_codes($date , $year , $branch){
    $data['month_ser'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->where('journal_date' , 'like' , date("Y-m" , strtotime($date))."%" )
            ->max('month_ser') ) + 1 ;

    $data['journal_code'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->max('journal_code') ) + 1 ;

    $data['branch_ser'] = intval( DB::table('daily_journal_m')
            ->where('finance_year_id' , $year)
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

    return $data;
}

function get_return_invoice_next_codes($date , $year , $branch){
    $data['month_ser'] = intval( DB::table('q_return_sales_m')
            ->where('finance_year_id' , $year)
            ->where('invoice_date' , 'like' , date("Y-m" , strtotime($date))."%" )
            ->max('month_ser') ) + 1 ;

    $data['invoice_ser'] = intval( DB::table('q_return_sales_m')
            ->where('finance_year_id' , $year)
            ->max('invoice_ser') ) + 1 ;

    $data['branch_ser'] = intval( DB::table('q_return_sales_m')
            ->where('finance_year_id' , $year)
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

    return $data;
}






function gold_converter($c_18 , $c_21 , $c_24 , $c_22 = 0)
{

    // $data['c_18'] = round( $c_18 + ( $c_21 * 0.875 / 0.75  ) + ( $c_24 / 0.75 ) , 3 ) ;
    // $data['c_21'] = round( ( $c_18 * 0.75 / 0.875  ) + $c_21  + ( $c_24 / 0.875 ) , 3)  ;
    // $data['c_24'] = round( ( $c_18 * 0.75 ) + ( $c_21 * 0.875 ) +  $c_24 , 3 )  ;

    $data['c_18'] = round( $c_18 + ( $c_21 * 0.875 / 0.75  ) + ( $c_22 * 0.917 / 0.75  ) + ( $c_24 / 0.75 ) , 3 ) ;
    $data['c_21'] = round( ( $c_18 * 0.75 / 0.875  ) + $c_21  + ( $c_22 * 0.917 / 0.875  )  + ( $c_24 / 0.875 ) , 3)  ;
    $data['c_22'] = round( ( $c_18 * 0.75 / 0.917  ) + ( $c_21 * 0.875 /  0.917 )  + $c_22 + ( $c_24 / 0.917 ) , 3)  ;
    $data['c_24'] = round( ( $c_18 * 0.75 ) + ( $c_21 * 0.875 ) + ( $c_22 * 0.917  )  +  $c_24 , 3 )  ;

    return $data;
}

function get_used_next_codes($date , $year , $branch , $type){
    $data['month_ser'] = intval( DB::table('used_factory')
            ->where('used_type_id' , $type)
            ->where('finance_year_id' , $year)
            ->where('add_date' , 'like' , date("Y-m" , strtotime($date)).'%' )
            ->max('month_ser') ) + 1 ;

    $data['action_code'] = intval( DB::table('used_factory')
            ->where('used_type_id' , $type)
            ->where('finance_year_id' , $year)
            ->max('action_code') ) + 1 ;

    $data['branch_ser'] = intval( DB::table('used_factory')
            ->where('used_type_id' , $type)
            ->where('finance_year_id' , $year)
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

    return $data;
}



function get_item_balance($params)
{
    ( isset($params['lang']) ) ? $lang = $params['lang']  : $lang = 'en';

    if( isset($params['branch']) && $params['branch'] > 0 ){
        $filter['branch']   = $params['branch']  ;
    }elseif( isset($params['branch_id']) && $params['branch_id'] > 0 ){
        $filter['branch']   = $params['branch_id']  ;
    }else{
        $filter['branch']   = [];
    }

    $query  = DB::table('all_items')
        ->join('map_categorys' , 'all_items.category_id' , '=' , 'map_categorys.category_id')
        ->join('map_sub_categorys' , 'all_items.sub_category_id' , '=' , 'map_sub_categorys.sub_category_id')
        ->join('gold_price', function ($join) {
            $join->where('gold_price.active', '=', '1');
        })
        ->selectRaw('
            all_items.id as item_id ,
            all_items.id as item_code ,
            all_items.name_'.$lang.' as name ,
            all_items.name_ar ,
            all_items.name_en ,
            all_items.category_id ,
            map_categorys.category_title_'.$lang.' as cat_name ,
            all_items.sub_category_id ,
            map_sub_categorys.sub_category_title_'.$lang.' as sub_name ,
            map_sub_categorys.sub_category_code ,
            all_items.purchase_cost ,
            all_items.sell_cost ,
            all_items.min_sell_cost ,
            all_items.editable ,
            all_items.branch_id ,

            weight ,
            in_type ,
            in_id ,
            out_type ,
            out_id ,

            all_items.in_id as invoice_id ,
            case
               when all_items.category_id = 18 then ( (weight * 18_price ) + ( weight * (purchase_cost) ))
               when all_items.category_id = 21 then ( (weight * 21_price ) + ( weight * (purchase_cost) ))
               when all_items.category_id = 22 then ( (weight * 22_price ) + ( weight * (purchase_cost) ))
               when all_items.category_id = 24 then ( (weight * 24_price ) + ( weight * (purchase_cost) ))
            end as base_price ,
            if( editable = 1 ,
            case
               when all_items.category_id = 18 then ( (weight * 18_price ) + ( weight * (sell_cost+purchase_cost) ))
               when all_items.category_id = 21 then ( (weight * 21_price ) + ( weight * (sell_cost+purchase_cost) ))
               when all_items.category_id = 22 then ( (weight * 22_price ) + ( weight * (sell_cost+purchase_cost) ))
               when all_items.category_id = 24 then ( (weight * 24_price ) + ( weight * (sell_cost+purchase_cost) ))
            end , final_price ) as price ,
            if( editable = 1 ,
            case
               when all_items.category_id = 18 then ( (weight * 18_price ) + ( weight * (min_sell_cost+purchase_cost) ))
               when all_items.category_id = 21 then ( (weight * 21_price ) + ( weight * (min_sell_cost+purchase_cost) ))
               when all_items.category_id = 22 then ( (weight * 22_price ) + ( weight * (min_sell_cost+purchase_cost) ))
               when all_items.category_id = 24 then ( (weight * 24_price ) + ( weight * (min_sell_cost+purchase_cost) ))
            end , final_price ) as min_price ,
            "in_type" as _table ');

    if(isset($params['category'])  && $params['category'] > 0){
        $query->where('all_items.category_id' , $params['category']);
    }

    if(isset($params['sub_category']) && $params['sub_category'] > 0){
        $query->where('all_items.sub_category_id' , $params['sub_category']);
    }

    if(isset($params['invoice_id'])){
        $query->where('all_items.in_id' , $params['invoice_id']);
    }

    if(isset($params['table_id'])){
        $query->where('all_items.in_type' , $params['table_id']);
    }

    if(isset($params['in_type'])){
        $query->where('all_items.in_type' , $params['in_type']);
    }


    if(isset($params['item_id'])){
        $query->where(function($query2) use($params)
        {
            $query2->where('all_items.id', '=', $params['item_id'])
                ->orWhere('all_items.old_code', '=', $params['item_id'] );
        });
    }


    if(isset($params['item_code'])){
        $query->where(function($query2) use($params)
        {
            $query2->where('all_items.id', '=', $params['item_code'])
                ->orWhere('all_items.old_code', '=', $params['item_code'] );
        });
    }

    if(isset($params['weight'])){
        $query->where('all_items.weight' , $params['weight']);
    }

    if(isset($params['purchase_cost'])){
        $query->where('all_items.purchase_cost' , $params['purchase_cost']);
    }

    if(is_array($filter['branch'])){
        $query->whereIn('all_items.branch_id' , $filter['branch']);
    }else{
        $query->where('all_items.branch_id' , $filter['branch']);
    }

    if(isset($params['editable'])){
        $query->where('all_items.editable' , $params['editable']);
    }

    if(isset($params['add_date'])){
        $query->where('all_items.add_date' , 'like' ,$params['add_date']."%");
    }


    $data = $query->get()->all();
    return $data;


    // ( isset($params['lang']) ) ? $filter['lang'] = $params['lang']  : $filter['lang'] = 'en';
    // ( isset($params['category']) ) ? $filter['category'] = $params['category']  : $filter['category'] = 0;
    // ( isset($params['sub_category']) ) ? $filter['sub_category'] = $params['sub_category']  : $filter['sub_category'] = 0;
    // ( isset($params['invoice_code']) ) ? $filter['invoice_code'] = $params['invoice_code']  : $filter['invoice_code'] = '';
    // ( isset($params['invoice_id']) ) ? $filter['invoice_id'] = $params['invoice_id']  : $filter['invoice_id'] = 0;
    // ( isset($params['item_id']) ) ? $filter['item_id'] = $params['item_id']  : $filter['item_id'] = 0;
    // ( isset($params['table_id']) ) ? $filter['table_id'] = $params['table_id']  : $filter['table_id'] = '';
    // ( isset($params['editable']) ) ? $filter['editable'] = $params['editable']  : $filter['editable'] = 0;
    // ( isset($params['weight']) ) ? $filter['weight'] = $params['weight']  : $filter['weight'] = 0;
    // ( isset($params['purchase_cost']) ) ? $filter['purchase_cost'] = $params['purchase_cost']  : $filter['purchase_cost'] = 0;
    // ( isset($params['branch']) ) ? $filter['branch'] = $params['branch']  : $filter['branch'] = 0;

    // if( isset($params['branch']) && $params['branch'] > 0 ){
    //     $filter['branch']   = $params['branch']  ;
    //     $filter['branchs']  = "";
    // }else{
    //     $filter['branch']   = 0 ;
    //     $filter['branchs']  = session()->get('my_branch_ids');
    // }

    // $data = DB::select('call p_item_balance(
    //     "'.$filter['lang'].'",
    //     '.$filter['category'].',
    //     '.$filter['sub_category'].',
    //     '.$filter['branch'].',
    //     "'.$filter['invoice_code'].'",
    //     '.$filter['invoice_id'].',
    //     '.$filter['item_id'].',
    //     "'.$filter['table_id'].'",
    //     '.$filter['editable'].' ,
    //     "'.$filter['branchs'].'",
    //     "'.$filter['weight'].'",
    //     "'.$filter['purchase_cost'].'"
    // )  ');
    // return $data;
}

function update_item_balance($t , $id , $update_array)
{

    $update_array['disabled_date']  = date("Y-m-d H:i:s");
    $update_array['disabled_user']  = auth()->user()->id;

    DB::table('all_items')->where('id' , $id )->update( $update_array );
    return '';

    switch ($t) {
        case 'p':
            DB::table('purchase_invoice_gold_d')->where('purchase_invoice_d_id' , $id )->update( $update_array );
            break;
        case 'u':
            DB::table('used_factory_products')->where('used_factory_product_id' , $id )->update( $update_array );
            break;
        case 's':
            DB::table('stocktaking_d')->where('stocktaking_d_id' , $id )->update( $update_array );
            break;
    }
}

