<?php

namespace App\Http\Controllers\API\V1\Assets;

use App\Classes\General\Upload;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Assets\Assets;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\AssetsDevelop;
use App\Models\Finance\AccountTree;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File as FacadesFile;

class AssetsDevelopController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');

        $this->filter = array(
            'lang'        => $lang ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']       = AssetsDevelop::all_assets_develop($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));

        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $insert = [
            'doc_date'          => $input['doc_date'] ?? date('Y-m-d'),
            'asset_m_id'        => $input['asset_m_id'],
            'price'             => $input['price'] ?? 0,
            'value_added'       => $input['value_added'] ?? 0,
            'payment_method'    => $input['payment_method'] ?? 1,
            'account_number'    => $input['account_number'] ?? 0,
            'doc_number'        => $input['doc_number'] ?? 0,
            'notes'             => $input['notes'] ?? null,
            'add_user'          => auth()->user()->id,
        ];
        $validator = validator()->make( $insert , AssetsDevelop::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        DB::beginTransaction();
        $this->return['id'] = AssetsDevelop::add_assets_develop($insert);

        Assets::update_assets_m(array('is_developed' => 1),$input['asset_m_id']);
        DB::commit();
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['item']           = AssetsDevelop::get_assets_develop($id,$lang);
        $this->return['attachments']    = AssetsDevelop::get_assets_develop_attachments($lang,$id);
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));

        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));
        return $this->sendResponse( $this->return);
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();

        $update = [
            'doc_date'          => $input['doc_date'],
            'asset_m_id'        => $input['asset_m_id'],
            'price'             => $input['price'],
            'value_added'       => $input['value_added'],
            'payment_method'    => $input['payment_method'],
            'account_number'    => $input['account_number'],
            'doc_number'        => $input['doc_number'] ?? 0,
            'notes'             => $input['notes'],
        ];

        $validator  = validator()->make( $update , AssetsDevelop::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        AssetsDevelop::update_assets_develop($update ,$id );


        $this->return = AssetsDevelop::get_assets_develop($id,$lang);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function add_attachments(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();

                $upload = (new Upload)->uploadFile($input['file_url'], 'assets_develop_attachments', $input['file_name']);
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));

                $this->return['id'] = DB::table('assets_develop_attachments')->insert([
                    'assets_develop_id' => $input['assets_develop_id'],
                    'file_name'         => $upload['filename'],
                    'file_url'          => $upload['url'],
                    'add_user'          => auth()->user()->id,
                ]);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('06-021','delete');

        $file_url = DB::table('assets_develop_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the server
        if ($file_url && FacadesFile::exists(public_path($file_url))) {
            FacadesFile::delete(public_path($file_url));
        }
        AssetsDevelop::delete_develop_attachments($id);
        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }


}
