<?php

namespace App\Http\Controllers\API\V1\Assets;

use App\Classes\General\Upload;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Assets\Assets;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\AssetsSelling;
use App\Models\Finance\AccountTree;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File as FacadesFile;

class AssetsSellingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');

        $this->filter = array(
            'lang'        => $lang ,
            'rows'        => $request['rows'] ?? 15 ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']       = AssetsSelling::all_assets_selling($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));

        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $insert = [
            'doc_date'          => $input['doc_date'] ?? date('Y-m-d'),
            'asset_m_id'        => $input['asset_m_id'],
            'sale_type'         => $input['sale_type'] ?? 1,
            'exchange_price'    => $input['exchange_price'] ?? 0,
            'value_added'       => $input['value_added'] ?? 0,
            'rec_value_added'   => $input['rec_value_added'] ?? 0,
            'payment_method'    => $input['payment_method'] ?? 1,
            'account_number'    => $input['account_number'] ?? 0,
            'doc_number'        => $input['doc_number'] ?? 0,
            'notes'             => $input['notes'] ?? null,
            'add_user'          => auth()->user()->id,
        ];
        $validator = validator()->make( $insert , AssetsSelling::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        DB::beginTransaction();
        $this->return['id'] = AssetsSelling::add_assets_selling($insert);

        Assets::update_assets_m(array('is_sold' => 1),$input['asset_m_id']);
        DB::commit();

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['item']           = AssetsSelling::get_assets_selling($id,$lang);
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['attachments']    = AssetsSelling::get_assets_selling_attachments($lang,$id);
        $this->return['assets']         = Assets::all_assets_m(array('active'=>1,'is_sold'=>0,'lang'=>$lang));
        return $this->sendResponse( $this->return);
    }


    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();

        $update = [
            'doc_date'          => $input['doc_date'] ?? null,
            'asset_m_id'        => $input['asset_m_id'] ?? 0,
            'sale_type'         => $input['sale_type'] ?? 1,
            'exchange_price'    => $input['exchange_price'] ?? 0,
            'value_added'       => $input['value_added'] ?? 0,
            'rec_value_added'   => $input['rec_value_added'] ?? 0,
            'payment_method'    => $input['payment_method'] ?? 1,
            'account_number'    => $input['account_number'] ?? 0,
            'doc_number'        => $input['doc_number'] ?? 0,
            'notes'             => $input['notes'] ?? null,
        ];

        $validator  = validator()->make( $update , AssetsSelling::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        AssetsSelling::update_assets_selling($update ,$id );

        $this->return = AssetsSelling::get_assets_selling($id,$lang);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function add_attachments(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();

                $upload = (new Upload)->uploadFile($input['file_url'], 'assets_selling_attachments', $input['file_name']);
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));

                $this->return['id'] = DB::table('assets_selling_attachments')->insert([
                    'assets_selling_id' => $input['assets_selling_id'],
                    'file_name'         => $upload['filename'],
                    'file_url'          => $upload['url'],
                    'add_user'          => auth()->user()->id,
                ]);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('06-021','delete');

        $file_url = DB::table('assets_selling_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the server
        if ($file_url && FacadesFile::exists(public_path($file_url))) {
            FacadesFile::delete(public_path($file_url));
        }
        AssetsSelling::delete_selling_attachments($id);
        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }


}
