<?php

namespace App\Http\Controllers\API\V1\Assets;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\Assets;
use App\Models\Assets\AssetsCategories;
use App\Models\Assets\DepreciationCalculate;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DepreciationCalculateController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');
        $this->filter = array(
            'lang'        => $lang ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'depr_month'  => $request['depr_month'] ?? null ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']          = DepreciationCalculate::all_depr_calculations_m($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['assets_categories']  = AssetsCategories::all_assets_category(['active' => 1 , 'lang'=>$lang]);
        $this->return['assets']             = Assets::all_assets_m(['active' => 1 , 'lang'=>$lang]);

        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $branch_id    = $this->data['shift']->branch_id ?? $this->data['current_branch'] ?? 0;
        $year   = array_search(date("Y", strtotime($input['action_date'])), $this->data['years']);
        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }
            $insert_m = [
                'finance_year_id'       => $year,
                'branch_id'             => $branch_id,
                'action_date'           => $input['action_date'] ?? date('Y-m-d'),
                'asset_category_id'     => $input['asset_category_id'] ?? null  ,
                'assets_ids'            => isset($input['assets_ids']) && is_array($input['assets_ids']) ? implode(',', $input['assets_ids']): null,
                // 'deprecation_from'      => $input['deprecation_from'] ,
                'deprecation_to'        => $input['deprecation_to'] ,
                'add_user'              => auth()->user()->id,
            ];
        DB::beginTransaction();
        $this->return['id'] = DepreciationCalculate::add_depr_calculations_m($insert_m);
        foreach ($input['details'] as $item){

            $insert = [
                'dep_calc_m_id'         => $this->return['id'],
                'asset_m_id'            => $item['asset_m_id'],
                'value'                 => $item['value'],
                'daily_depreciation'    => $item['daily_depreciation'],
                'total_deprecation'     => $item['total_deprecation'],
                'remaining_value'       => $item['remaining_value'],
            ];
            $validator = validator()->make( $insert , DepreciationCalculate::$rules );
            if($validator->fails())
            {
                return $this->sendError( trans('error.add_fails') , $validator->errors() );
            }

            DepreciationCalculate::add_depr_calculations_d($insert);
            $asset = Assets::get_assets_m($item['asset_m_id'], 'ar');
            if($insert['remaining_value'] == 1){
                $status = 5;
            }else{
                $status = 2;
            }
            $asset_update = [
                'remain_value'              => $item['remaining_value'] ,
                'depr_value'                =>($asset->depr_value + $insert['total_deprecation']) ,
                'status'                    => $status ,
                'last_month_depreciation'   => $insert_m['deprecation_to']
            ];
            Assets::update_assets_m( $asset_update, $item['asset_m_id']);

        }
        DB::commit();
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']   = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['items']         = DepreciationCalculate::get_depr_calculations_m($id, $lang);
        $this->return['details']       = DepreciationCalculate::get_depr_calculations_d($id, $lang);

        return $this->sendResponse( $this->return , '' );
    }
    public function get_calculation($lang, Request $request){
        $filter = [
            'lang'                  => $lang,
            'category'              => $request['category'] ?? null,
            'ids'                   => $request['assets_ids'] ?? null,
            'destruction_calculate' => 0
        ];

        $assets = collect( Assets::all_assets_m($filter))->where('remain_value' , '>' , 1)->where('last_month_depreciation' , '<' , $request['deprecation_to'])->all();
        $this->return['details'] = [];
        foreach ($assets as $asset){
            $from = $asset->last_month_depreciation;
            $to = Carbon::parse($request['deprecation_to']);
            $diff = $to->diff($from);
            $calculation_days = $diff->days;


            $total_deprecation = $asset->daily_depreciation * $calculation_days;
            if($total_deprecation >= $asset->remain_value){
                $total_deprecation = $asset->remain_value - 1;
                $remaining_value = $asset->remain_value - $total_deprecation;
            }else{
                $remaining_value = $asset->remain_value - $total_deprecation;
            }
            $this->return['details'][] = [
                'asset_m_id'         => $asset->id,
                'asset_name'         => $asset->name,
                'value'              => $asset->remain_value,
                'daily_depreciation' => $asset->daily_depreciation,
                'total_deprecation'  => $total_deprecation,
                'remaining_value'    => $remaining_value,
            ];
        }
        return $this->sendResponse( $this->return);

    }
    public function destroy($lang , $id )
    {
        $this->checkPermission('06-021','delete');
        $master     = DepreciationCalculate::get_depr_calculations_m($id, $lang);
        //check if this is the last depr
        $count = DB::table('assets_dep_calc_m')->where('dep_calc_m_id','>',$id)->count();
        if($count > 0){
            return $this->sendError(trans('error.you_must_delete_last_calculation_first'));
        }
        $details    = DepreciationCalculate::get_depr_calculations_d($id, $lang);
        DB::beginTransaction();
        foreach ($details as $item){

        }
        DB::commit();
        return $this->sendResponse(trans('main.delete_success'));
    }
}
