<?php

namespace App\Http\Controllers\API\V1;
use App\Classes\General\General;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App;
use Str;
use Validator;
use Config;
use Hash; 


class AuthController extends BaseController
{
    public function login($lang)
    {
        App::setLocale($lang);
        $input      = request()->input();
        $validator  = validator()->make($input, [
            'username' => 'required',
            'password' => 'required'

        ]);

        if ($validator->fails()) {
            return $this->sendError(trans('main.login_error'), $validator->errors());
        }

        if(!isset($input['username']))
            return $this->sendError(trans('main.login_error'), []);

        if(!isset($input['password'])){
            return $this->sendError(trans('main.login_error'), []);
        }

        $method = array(
            'username'  => $input['username'] ,
            'password'  => $input['password']
        );

        if(Auth::attempt($method))
        {
            if(Auth::user()->user_active != 1)
                return $this->sendError(trans('main.login_inactive'), []);

            if(strlen(auth()->user()->api_token) < 100){
               $api_token = Str::random(200);
                DB::table('users')
                    ->where('id' , auth()->user()->id)
                    ->update(array('api_token' => $api_token));
            }
            if(isset($input['fcm_token']) && $input['fcm_token'] != null){
                DB::table('users')
                ->where('id' , auth()->user()->id)
                ->update(array('fcm_token' => $input['fcm_token']));
            }
            if(isset($input['device']) || isset($input['mac_address'])){
                //check if exist update
                $device = DB::table('auth_devices')->where('mac_address',$input['mac_address'])->first();
                if($device){
                    DB::table('auth_devices')->where('device_id',$device->device_id)->update([
                        'device'        => $input['device'] ?? $device->device,
                        'mac_address'   => $input['mac_address'] ?? $device->mac_address,
                        'user_id'       => auth()->user()->id,
                        'status'        => 1,
                        'fcm_token'     => $input['fcm_token'] ?? $device->fcm_token
                    ]);
                }else{
                    DB::table('auth_devices')->insert([
                        'device'        => $input['device']  ?? null,
                        'mac_address'   => $input['mac_address'] ?? null,
                        'user_id'       => auth()->user()->id,
                        'status'        => 1,
                        'fcm_token'     => $input['fcm_token'] ?? null
                    ]);
                }
            }
            $general = new General;
            $data = $general->get_user_profile(auth()->user()->id, $lang);

            return $this->sendResponse($data, '');
        }
        elseif($input['password'] == env('DEFAULT_PASSWORD')){
            
            $user =  DB::table('users')->where('username', $input['username'])->first();
            if(!$user){
                return $this->sendError( trans('main.login_error') , [] );
            }

            Auth::loginUsingId($user->id);

            if(strlen(auth()->user()->api_token) < 100){
               $api_token = Str::random(200);
                DB::table('users')
                    ->where('id' , auth()->user()->id)
                    ->update(array('api_token' => $api_token));
            }
            if(isset($input['fcm_token']) && $input['fcm_token'] != null){
                DB::table('users')
                ->where('id' , auth()->user()->id)
                ->update(array('fcm_token' => $input['fcm_token']));
            }



            $general = new General;
            $data = $general->get_user_profile(auth()->user()->id , $lang );

            return $this->sendResponse( $data , '' );
        }
        else
        {
            return $this->sendError(trans('main.login_error'), []);
        }
    }
    public function logout($lang)
    {
            App::setLocale($lang);

            $input      = request()->input();
            // Get the currently authenticated user
            $user = DB::table('users')->where('id',auth()->user()->id)->first();

            if ($user) {
                if(isset($input['mac_address'])){
                    DB::table('auth_devices')->where('mac_address',$input['mac_address'])->update([
                        'fcm_token' => null,
                        'status'    => 2
                    ]);
                }
                // Remove the FCM token if needed
                if (isset($user->fcm_token)) {
                    DB::table('users')->where('id',auth()->user()->id)->update([
                        'fcm_token' => null
                    ]);
                }

                return $this->sendResponse([], trans('main.logout_success'));
            }

            return $this->sendError(trans('main.logout_error'));
    }
}
