<?php

namespace App\Http\Controllers\API\V1\Barbers;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Barbers\Barber;
use App\Models\Barbers\BarberVacation;
use App\Models\Main\ScreenSub;
use DateTime;
use Illuminate\Http\Request;

class BarberVacationController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('view permission needed #10-002', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? 20 ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['items']       = BarberVacation::all_barber_vacations($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['barbers']     = Barber::all_barbers(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if (!@in_array('2', $this->data['mypermissions']['10-002'][0]->permission ?? [])) {
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $insert = $request->only(['barber_id', 'from_date', 'to_date']);

        $validator = validator()->make($insert, BarberVacation::$rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $insert['add_user'] = auth()->user()->id;

        // Get Days Count
        $from_date = new DateTime($insert['from_date']);
        $to_date   = new DateTime($insert['to_date']);
        $insert['days_count'] = $to_date->diff($from_date)->format('%a');

        $this->return['id'] = BarberVacation::add_barber_vacation($insert);
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('show permission needed #10-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-002', $lang)->sub_title ?? '';
        $this->return['data']        = BarberVacation::get_barber_vacation($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if (!@in_array('3', $this->data['mypermissions']['10-002'][0]->permission ?? [])) {
            return $this->sendError('create permission needed #10-002', [], 200);
        }

        $update = $request->only(['barber_id', 'from_date', 'to_date']);

        $validator = validator()->make($update, BarberVacation::$rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        // Get Days Count
        $from_date = new DateTime($update['from_date']);
        $to_date   = new DateTime($update['to_date']);
        $update['days_count'] = $to_date->diff($from_date)->format('%a');

        BarberVacation::update_barber_vacation($update, $id);
        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
            return $this->sendError('delete permission needed #10-002', [], 200);
        }

        BarberVacation::delete_barber_vacation($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = BarberVacation::find($id);

        if($item->barber_vacation_active){
            if(!@in_array('4', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
                return $this->sendError('update permission needed #10-002', [], 200);
            }

            BarberVacation::delete_barber_vacation($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['10-002'][0]->permission ?? [])){
                return $this->sendError('update permission needed #10-002', [], 200);
            }

            BarberVacation::update_barber_vacation(array('barber_vacation_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
