<?php

namespace App\Http\Controllers\API\V1\Contracts;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Models\Main\Setting;
use App\Models\Finance\Tax;
use App\Models\Sales\Customer;
use App\Models\Main\ScreenSub;
use App\Models\Contracts\Contract;
use App\Models\Contracts\ContractType;
use App\Classes\Sales\SalesInvoiceHelper;
use App\Models\Sales\SalesAgent;
use App\Models\Sales\SalesInvoice;
use App\Models\Finance\CostCenter;

use DB;

class ContractController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }
        $this->filter = array(
            'lang'         => $lang ,
            'active'       => $request['active'] ?? 1 ,
            'status'       => $request['status'] ?? 1 ,
            'rows'         => $request['rows'] ?? null ,
            'page'         => $request['page'] ?? 1 ,
            'customer_id'  => $request['customer_id'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-002', $lang)->sub_title ?? '';
        $this->return['items']       = Contract::all_contracts($this->filter);
        $this->return['customers']   = Customer::all_customers(['lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse($this->return);
    }

    public function all_contract_d($lang , Request $request)
    {


        if(!@in_array('1', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }
        $this->filter = array(
            'lang'       => $lang ,
            'active'     => $request['active'] ?? 1 ,
            'rows'       => $request['rows'] ?? null ,
            'page'       => $request['page'] ?? 1 ,
            'word'       => $request['word'] ?? null ,
            'customer_id'  => $request['customer_id'] ?? null ,
            'contract_id'  => $request['contract_id'] ?? null ,
            'due'        => $request['due'] ?? null ,
            'start_date' => $request['start_date'] ?? null ,
            'end_date'   => $request['end_date'] ?? null ,
            'status'     => $request['status'] ?? null ,

        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-002', $lang)->sub_title ?? '';
        $this->return['items']       = Contract::all_contract_d($this->filter);
        $this->return['customers']   = Customer::all_customers(['lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse($this->return);
    }

    public function create($lang)
    {

        if(!@in_array('1', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-002', $lang)->sub_title ?? '';
        $this->return['customers']   = Customer::all_customers(['lang' => $lang , 'active' => 1 ]);
        $this->return['taxes']       = Tax::all_taxes(['lang' => $lang , 'active' => 1 ]);
        $this->return['contract_types']= ContractType::all_contract_types(['lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse($this->return);
    }

    public function store($lang , Request $request)
    {

        if(!@in_array('2', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('create permission needed #08-002', [], 200);
        }

        $insert             = $request->only(['contract_type_id','customer_id','notes','amount','is_taxable','tax_id','contract_period','end_date','start_date','payment_method','repayment_period']);
        $insert['add_user'] = auth()->user()->id;


        $validator          = validator()->make($insert, Contract::$rules);
        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }


        if(@$insert['is_taxable']){
            $tax_amount = ( DB::table('taxes')->where('tax_id',$request->tax_id)->first()->tax_percentage / 100 ) ;
            $insert['amount_with_vat']  = $insert['amount']  * ( 1 + $tax_amount );
            $insert['total_vat']        = $insert['amount']  * $tax_amount ;
        }else{
            $insert['amount_with_vat'] = $insert['amount'];
            $insert['total_vat']      = 0 ;
        }

        if(collect($request['contract_d'])->sum('installment_amount') != $insert['amount_with_vat'] ){
            return $this->sendError(trans('error.add_fails'), ['Total installments are not equal to the contract value']);
        }

        DB::beginTransaction();

        $this->return  = Contract::add_contract($insert);

        foreach($request->contract_d as $details){

            $seed = [
                'due_date'           => $details['due_date'],
                'installment_amount' => $details['installment_amount'],
                'total_vat'          => 0 ,
                'amount_with_vat'    => $details['installment_amount'] ,
                'contract_id'        => $this->return,
            ];

            if(@$insert['is_taxable']){
                $seed['installment_amount'] = ( $seed['installment_amount'] / ( 1 + $tax_amount ) );
                $seed['total_vat']          = $seed['amount_with_vat'] - $seed['installment_amount'];
            }


            DB::table('contract_d')->insert($seed);
        }
        DB::commit();

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }

        $this->return['screen_name']      = ScreenSub::get_screen_sub_by_screen_code('08-002', $lang)->sub_title ?? '';
        $this->return['contract_master']  = Contract::get_contract($id, $lang);
        $this->return['contract_details'] = Contract::all_contract_d(['lang' => $lang , 'active' => 1 , 'contract_id' => $id ]);

        $this->return['customers']        = Customer::all_customers(['lang' => $lang , 'active' => 1 ]);
        $this->return['taxes']            = Tax::all_taxes(['lang' => $lang , 'active' => 1 ]);
        $this->return['contract_types']   = ContractType::all_contract_types(['lang' => $lang , 'active' => 1 ]);

        $this->return['next_item']      = Contract::get_next( $id , $this->data['current_branch'] )->m_id ?? 0;
        $this->return['previous_item']  = Contract::get_previous($id , $this->data['current_branch'] )->m_id ?? 0;
        $this->return['first_item']     = 1;
        $this->return['last_item']      = Contract::get_last($this->data['current_branch'] )->m_id ?? 0;



        return $this->sendResponse($this->return);
    }


    public function update($lang ,$id, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('create permission needed #08-002', [], 200);
        }

        $update    = $request->only(['contract_type_id','customer_id','notes','amount','is_taxable','tax_id','contract_period','end_date','start_date','payment_method','repayment_period']);
        $validator = validator()->make($update, Contract::$rules);
        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        if(@$update['is_taxable']){
            $tax_amount = ( DB::table('taxes')->where('tax_id',$request->tax_id)->first()->tax_percentage / 100 ) ;
            $update['amount_with_vat']  = $update['amount']  * ( 1 + $tax_amount );
            $update['total_vat']        = $update['amount']  * $tax_amount ;
        }else{
            $update['amount_with_vat'] = $update['amount'];
            $update['total_vat']      = 0 ;
        }

        if(collect($request['contract_d'])->sum('installment_amount') != $update['amount_with_vat'] ){
            return $this->sendError(trans('error.add_fails'), ['Total installments are not equal to the contract value']);
        }

        DB::beginTransaction();

            $update['add_user'] = auth()->user()->id;
            $this->return       = Contract::update_contract($update,$id);

            DB::table('contract_d')
                ->whereNotIn('contract_d_id' , collect($request['contract_d'])->pluck('id')->toArray() )
                ->where('contract_id' , $id )
                ->where('contract_d_active' ,1)
                ->update(['contract_d_active' => 0 , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ] );

            if(isset($request['contract_d']) && is_array($request['contract_d']) && count($request['contract_d']) > 0 )
            {
                foreach ($request['contract_d'] as $row){
                    if(isset($row['id']) && $row['id'] > 0 ){
                        $d_id = $row['id'];
                        unset($row['id']);
                        Contract::update_contract_d($row , $d_id );
                    }else{
                        unset($row['id']);
                        $row['contract_id'] = $id;
                        $row['add_user']    = auth()->user()->id ;
                        Contract::add_contract_d( $row );
                    }
                }
            }

        DB::commit();
        return $this->sendResponse($this->return, trans('main.update_success'));
    }


    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('delete permission needed #08-002', [], 200);
        }

        Contract::delete_contract($id);
        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function create_contract_invoice_get($lang){

        if(!@in_array('3', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('08-002', $lang)->sub_title ?? '';
        $this->return['cost_centers']   = CostCenter::active_cost_centers( $lang , [ 'active' => 1 , 'account_type' => 2 ] );
        $this->return['sales_agents']   = SalesAgent::all_sales_agents( [ 'lang' => $lang , 'active' => 1 , 'account_type' => 2 ] );

        
        return $this->sendResponse( $this->return , '' );

    }

    public function create_contract_invoice_post($lang, Request $request){
      
        if(!@in_array('3', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('view permission needed #08-002', $this->data, 200);
        }

        $insert = $request->only(['customer_id', 'proforma_invoice_id', 'link_cost_center', 'cost_center_id', 'sales_invoice_type_id', 'sales_invoice_date',
                                  'sales_invoice_description', 'sales_agent_id', 'supply_order', 'invoice_discount', 'discount_type', 'discount', 'items']);

        $year   = array_search(date("Y", strtotime($insert['sales_invoice_date'])), $this->data['years']);

        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        $codes = (new SalesInvoiceHelper)->get_next_codes($insert['sales_invoice_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'branch_id'                 => $this->data['current_branch'],
            'finance_year_id'           => $year,
            'year_ser'                  => $codes['year_ser'],
            'month_ser'                 => $codes['month_ser'],
            'branch_ser'                => $codes['branch_ser'],
            'daily_journal_m_id'        => 0,
            'customer_id'               => $insert['customer_id'],
            'proforma_invoice_id'       => $insert['proforma_invoice_id'] ?? 0,
            'link_cost_center'          => isset($insert['cost_center_id']) > 0 ? 1 : 0,
            'cost_center_id'            => $insert['cost_center_id'] ?? 0,
            'sales_invoice_type_id'     => $insert['sales_invoice_type_id'],
            'sales_invoice_date'        => $insert['sales_invoice_date'],
            'sales_invoice_description' => $insert['sales_invoice_description'],
            'sales_agent_id'            => $insert['sales_agent_id'],
            'supply_order'              => $insert['supply_order'] ?? '0',
            'invoice_discount'          => $insert['invoice_discount'] ?? 0,
            'discount_type'             => $insert['discount_type'] ?? 0,
            'discount'                  => $insert['discount'] ?? 0,
            'items_count'               => collect($insert['items'])->count(),
            'add_user'                  => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, SalesInvoice::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $m_id = SalesInvoice::add_sales_invoice_m($master_seed);

        if (isset($insert['items']) && is_array($insert['items'])){

            // Calculate Items Total Price
            $items_total_price = 0;
            foreach ($insert['items'] as $item){
                $items_total_price += $item['price'] * $item['quantity'];
            }

            foreach ($insert['items'] as $item){

                $tax_percentage = DB::table('taxes')
                    ->where('tax_id', $item['tax_id'])
                    ->value('tax_percentage');
                    

                $total_price  = ($item['price'] * $item['quantity']);

                $discount     = ($insert['discount_type'] == 1) ? $insert['discount'] : (($items_total_price) * ($insert['discount'] / 100));
                $discount_per = ($discount / $items_total_price);
                $total_price_after_discount = (($item['price'] * $item['quantity']) - ($discount_per * ($item['price'] * $item['quantity'])));
                $item_price_after_discount  = ($total_price_after_discount / $item['quantity']);

                $details_seed = array(
                    'sales_invoice_m_id'         => $m_id,
                    'item_id'                    => $item['item_id'],
                    'warehouse_id'               => $item['warehouse_id'] ?? 0 ,
                    'unit_id'                    => $item['unit_id']?? 0,
                    'unit_type'                  => $item['unit_type'] ?? 0,

                    'quantity'                   => $item['quantity'] ?? 0,
                    'price'                      => $item['price'],
                    'total_price'                => $total_price,
                    'tax_percent_id'             => $item['tax_id'] ?? 0,

                    'total_vat'                  => ($total_price_after_discount) * (($tax_percentage ?? 15) / 100),
                    'total_without_vat'          => ($total_price_after_discount),
                    'total_with_vat'             => ($total_price_after_discount) + (($total_price_after_discount) * (($tax_percentage ?? 15) / 100)),

                    'discount_per'               => $discount_per,
                    'discount'                   => ($discount_per * $total_price),

                    'total_price_after_discount' => $total_price_after_discount,
                    'item_price_after_discount'  => $item_price_after_discount,

                    'current_quantity'           => $item['quantity'] ?? 0,
                    'current_price'              => $item['price'],
                    'current_total_price'        => $total_price,
                    'current_total_price_after_discount' => $total_price_after_discount,

                    'current_total_vat'          => ($total_price_after_discount) * (($tax_percentage ?? 15) / 100),
                    'current_total_without_vat'  => ($total_price_after_discount),
                    'current_total_with_vat'     => ($total_price_after_discount) + (($total_price_after_discount) * (($tax_percentage ?? 15) / 100)),

                    'add_user'                   => auth()->user()->id,
                    'detail_type'                => 1,
                );

                $validator = validator()->make($details_seed, SalesInvoice::$details_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                $d_id = SalesInvoice::add_sales_invoice_d($details_seed);

               
            }
        }

        
        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    

    }

    public function installments_delay_transaction($lang, $id ,Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('create permission needed #08-002', [], 200);
        }

        $update             = $request->only(['delay_time']);
        $update['is_delay'] = 1;

        $validator          = validator()->make($update, Contract::$rules_delay);
        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $d = DB::table('contract_d')
            ->where('contract_d_id' , $id )
            ->first();

        if($d->due_date > $update['delay_time']){
            return $this->sendError(trans('error.add_fails'), ['error in date']);
        }

        Contract::update_contract_d($update,$id);
        $this->return = Contract::get_contract_d($d->contract_id , $lang);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function contract_activation($lang, $id ,Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['08-002'][0]->permission)){
            return $this->sendError('create permission needed #08-002', [], 200);
        }

        $update             = $request->only(['activation_type']);
        $update['status']   = 2;
        $update['add_user'] = auth()->user()->id;
        $this->return       = Contract::contract_activation($update,$id);

        return $this->sendResponse($this->return, trans('main.update_success'));

    }


}
