<?php
namespace App\Http\Controllers\API\V1\Contracts;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Models\Contracts\ContractType;
use App\Models\Main\ScreenSub;


use DB;



class ContractTypeController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['08-001'][0]->permission)){

            return $this->sendError('view permission needed #08-001', $this->data, 200);

        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-001', $lang)->sub_title ?? '';

        $this->return['items']       = ContractType::all_contract_types($this->filter);


        return $this->sendResponse($this->return);
    }




    public function create($lang , Request $request)

    {
        if(!@in_array('2', $this->data['mypermissions']['08-001'][0]->permission)){
            return $this->sendError('create permission needed #08-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-001' , $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }


    public function store($lang, Request $request)
    {

        if(!@in_array('2', $this->data['mypermissions']['08-001'][0]->permission)){
            return $this->sendError('create permission needed #08-001', [], 200);
        }

        $insert     = $request->only(['name_en','name_ar']);
        $validator  = validator()->make($insert, ContractType::$rules);

         if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $insert['add_user'] = auth()->user()->id;
        $this->return['id'] = ContractType::add_contract_type($insert);
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['08-001'][0]->permission)){
            return $this->sendError('show permission needed #08-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('08-001', $lang)->sub_title ?? '';
        $this->return['data']        = ContractType::get_contract_type($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['08-001'][0]->permission)){
            return $this->sendError('show permission needed #08-001', [], 200);
        }


        $update    = $request->only(['name_en','name_ar']);
        $validator = validator()->make($update, ContractType::$rules);


        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        
        ContractType::update_contract_type($update, $id);
        return $this->sendResponse($id, trans('main.update_success'));

    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['08-001'][0]->permission)){
            return $this->sendError('delete permission needed #08-001', [], 200);
        }

        ContractType::delete_contract_type($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }
    
    public function toggle_active($lang, $id)
    {
        $item = ContractType::find($id);

        if($item->contract_type_active){
            if(!@in_array('4', $this->data['mypermissions']['08-001'][0]->permission)){
                return $this->sendError('update permission needed #08-001', [], 200);
            }

            ContractType::delete_contract_type($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['08-001'][0]->permission)){
                return $this->sendError('update permission needed #08-001', [], 200);
            }

            ContractType::update_contract_type(array('contract_type_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
