<?php

namespace App\Http\Controllers\API\V1\Elevators;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Elevators\ElevatorModels;
use App\Models\Elevators\ElevatorTypes;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ElevatorModelsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('12-001','view');

        $this->filter = array(
            'lang'              => $lang ,
            'active'            => $request['active'] ?? 1 ,
            'rows'              => $request['rows'] ?? 20 ,
            'page'              => $request['page'] ?? 1 ,
            'word'              => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-001', $lang)->sub_title ?? '';
        $this->return['items']       = ElevatorModels::all_models($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('12-001','add');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-001', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('12-001','add');

        $inputs = $request->only(['models','type_name_ar','type_name_en']);

        $type_insert =[
            'name_en'  => $inputs['type_name_en'],
            'name_ar'  => $inputs['type_name_ar'],
        ];
        DB::beginTransaction();
        $type_id = ElevatorTypes::add_type($type_insert);

        if (isset($inputs['models']) && is_array($inputs['models'])){
            foreach ($inputs['models'] as $model){
                $master_seed = [
                    'name_en'           => $model['name_en'],
                    'name_ar'           => $model['name_ar'],
                    'elevator_type_id'  => $type_id,
                ];

                $validator = validator()->make($master_seed, ElevatorModels::$master_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }
                $m_id = ElevatorModels::add_model_m($master_seed);
                if (isset($model['items']) && is_array($model['items'])){
                    foreach ($model['items'] as $item){
                        $details_seed = array(
                            'model_m_id'        => $m_id,
                            'item_name'         => $item['item_name'],
                            'description'       => $item['description'],
                        );

                        $validator = validator()->make($details_seed, ElevatorModels::$details_rules);

                        if($validator->fails()){
                            return $this->sendError(trans('error.add_fails'), $validator->errors());
                        }
                        ElevatorModels::add_model_d($details_seed);
                    }
                }
            }
        }

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('12-001','view');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-001', $lang)->sub_title ?? '';
        $this->return['master']      = ElevatorModels::get_model_m($id, $lang);
        $this->return['details']     = ElevatorModels::get_model_d($id, $lang);

        return $this->sendResponse($this->return);
    }
    public function model_lookup($lang, $id)
    {
        $this->checkPermission('12-001','view');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-001', $lang)->sub_title ?? '';
        $this->return['items']      = ElevatorModels::get_model_lookup($lang, $id);

        return $this->sendResponse($this->return);
    }
    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('12-001','edit');

        $inputs = $request->only(['name_en', 'name_ar', 'items','type_name_ar','type_name_en']);

        $master_seed = [
            'name_en'  => $inputs['name_en'],
            'name_ar'  => $inputs['name_ar'],
        ];

        $validator = validator()->make($master_seed, ElevatorModels::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        ElevatorModels::update_model_m($master_seed, $id);

        if (isset($inputs['items']) && is_array($inputs['items'])){
            DB::table('elevators_models_d')->where('model_m_id',$id)->delete();
            foreach ($inputs['items'] as $item) {
                DB::table('elevators_models_d')->insert([
                        'model_m_id'   => $id,
                        'item_name'    => $item['item_name'],
                        'description'  => $item['description'],
                    ]);
            }
        }
        DB::commit();
        return $this->sendResponse($id, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('12-001','delete');

        ElevatorModels::delete_model_m($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = ElevatorModels::find($id);

        if($item->active){
            $this->checkPermission('12-001','view');

            ElevatorModels::delete_model_m($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('12-001','view');

            ElevatorModels::update_model_m(array('active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
