<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Finance\AccountTreeHelper;
use Illuminate\Validation\Rule;
use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Main\ScreenSub;

use DB;
class AccountTreeController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('02-001','view');


        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? null ,
            'word'        => $request['word'] ?? null ,
            'parent'      => $request['parent'] ?? null ,
            'account_type'=> $request['type'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-001' , $lang)->sub_title ?? '';
        $this->return['items']       = AccountTree::active_account_trees( $lang , $this->filter );

        foreach($this->return['items'] as $item){
            $item->children = [];
        }


        // $items       = DB::table('account_tree')
        //     ->where('parent_id' ,'>' , 0 )
        //     ->get();

        // if(request()->header('clientID') == '803'){

        //     foreach($items as $item){
        //         if($item->parent_id > 0 ){
        //             $code   = (new AccountTreeHelper)->get_next_account_tree2($item->parent_id);
        //             DB::table('account_tree')
        //                 ->where('account_tree_id' , $item->account_tree_id )
        //                 ->update(['new_code' => $code['new_code']]);
        //         }
        //     }
        // }



        return $this->sendResponse( $this->return );
    }

    public function store(Request $request)
    {
        $this->checkPermission('02-001','add');

        $code   = (new AccountTreeHelper)->get_next_account_tree($request['parent_id']);

        if(!$code['check']){
            return $this->sendError( $code['msg'] , [] );
        }

        $insert                     = $request->only(['name_en', 'name_ar', 'account_type', 'account_nature',
                                                      'protection', 'parent_id', 'cost_center',
                                                      'cost_center_id', 'main_account', 'level_chars']);
        $insert['account_code']     = $code['new_code'];
        if($insert['parent_id'] > 0){
            $parent = AccountTree::get_account_tree($insert['parent_id'] , 'en');
            $insert['account_level']  = $parent->account_level + 1;
        }
        if (isset($insert['cost_center_id'])){
            if(count($insert['cost_center_id']) >  0)
                $insert['cost_center_id']   = (is_array($insert['cost_center_id'] ?? ''))? implode('.' , $insert['cost_center_id']) : $insert['cost_center_id'];
            else
                unset( $insert['cost_center_id'] );
        }

        $insert['active']           = 1;
        $insert['add_user']         = auth()->user()->id;
        $validator                  = validator()->make( $insert , AccountTree::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id']     = AccountTree::add_account_tree($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id, Request $request){
        $this->checkPermission('02-001','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-001' , $lang)->sub_title ?? '';
        $this->return['item']           = AccountTree::get_account_tree($id , $lang);

        return $this->sendResponse( $this->return , [] );


    }

    public function update($lang , $id, Request $request)
    {
        $this->checkPermission('02-001','edit');


        $update     = $request->only(['name_en', 'name_ar', 'account_type', 'account_nature',
                                      'protection', 'parent_id',  'cost_center',
                                      'cost_center_id', 'main_account', 'level_chars']);

        if($update['parent_id'] > 0){
            $parent = AccountTree::get_account_tree($update['parent_id'] , 'en');
            $insert['account_level']  = $parent->account_level + 1;

        }
        if (isset($insert['cost_center_id'])){
            if(count($insert['cost_center_id']) >  0)
                $insert['cost_center_id']   = (is_array($insert['cost_center_id'] ?? ''))? implode('.' , $insert['cost_center_id']) : $insert['cost_center_id'];
            else
                unset( $insert['cost_center_id'] );
        }

        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('account_tree')->ignore($id,'account_tree_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('account_tree')->ignore($id,'account_tree_id'),
            ],
            'account_code' => [
                'string',
                Rule::unique('account_tree')->ignore($id,'account_tree_id'),
            ]
        ];
        $validator  = validator()->make( $update  , $update_rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        unset($update['_method'] , $update['account_tree_id'] , $update['account_code'] , $update['active']);
        if( !(new AccountTreeHelper)->can_edit_or_delete($id) ){
            unset($update['account_type'] , $update['account_nature'] );
        }

        AccountTree::update_account_tree($update ,  $id);

        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('02-001','delete');


        if( !(new AccountTreeHelper)->can_edit_or_delete($id) ){
            return $this->sendError( trans('error.delete_fails') , [] );
        }

        AccountTree::delete_account_tree($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang , $id){

        $item = AccountTree::find($id);
        if($item->active){

            $this->checkPermission('02-001','delete');


            if( !(new AccountTreeHelper)->can_edit_or_delete($id) ){
                return $this->sendError( trans('error.delete_fails') , [] );
            }

            AccountTree::delete_account_tree($id);
            $this->return['active'] = false;

        }else{
            $this->checkPermission('02-001','edit');


            AccountTree::update_account_tree(array('active' => 1 ) , $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
