<?php

namespace App\Http\Controllers\API\V1\Finance;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Finance\CashReceipt;
use App\Models\Main\ScreenSub;
use App\Models\Main\Bank;
use App\Models\Main\FinanceYear;
use Validator;
use DB;
class CashReceiptController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-006' , $this->data , 200 );
        }
        $this->filter                = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? 20 ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang)->sub_title ?? '';
        $this->return['items']       = CashReceipt::active_cash_receipt( $lang );
        return $this->sendResponse( $this->return );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-006' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang);
        $this->return['customers']      = [];
        $this->return['bank']            = Bank::all_banks($lang);
        $this->return['delegates']        = [];
        return $this->sendResponse( $this->return  );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-006' , [] , 200 );
        }
        $validator = validator::make( $request->all() , CashReceipt::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $seed = array(
            'date' => $request['date'] ,
            'from_type' => $request['from_type'] ,
            'user_id' => $request['user_id'],
            'delegate_id' => $request['delegate_id'], 
            'value' => $request['value'] , 
            'description' => $request['description'] , 
            'advance_payment' => $request['advance_payment'] ,
            'cost_center' => $request['cost_center'] ,
            'collection_method' => $request['collection_mehtod'] 
        );
        $seed['active'] = 1;

        if(isset($request['cost_center_id'])){
            $seed['cost_center_id'] = $request['cost_center_id'] ;
        }

        if(isset($request['bank_id'])){
            $seed['bank_id'] = $request['bank_id'];
        }

        CashReceipt::add_cash_receipt($seed);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'show permission needed #02-006' , [] , 200 );
        }
        $this->return['screen_name']          = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang)->sub_title ?? '';
        $this->return['data']                 = CashReceipt::get_cash_receipt($id);
        
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($lang , $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-006' , [] , 200 );
        }

        $update                         = $request->all();
        //dd($id);
        $validator = validator::make( $request->all() , CashReceipt::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        CashReceipt::update_cash_receipt($update ,  $id);

        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'delete permission needed #02-006' , [] , 200 );
        }
        CashReceipt::delete_cash_receipt($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }

}
