<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Finance\CostCenterHelper;
use Illuminate\Validation\Rule;

use App\Models\Finance\CostCenter;
use App\Models\Main\ScreenSub;

class CostCenterController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($lang , Request $request)
    {
        $this->checkPermission('02-002','view');

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? null ,
            'word'        => $request['word'] ?? null ,
            'parent'      => $request['parent'] ?? null ,
            'account_type'=> $request['type'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-002' , $lang)->sub_title ?? '';
        $this->return['items']       = CostCenter::active_cost_centers( $lang , $this->filter );

        foreach($this->return['items'] as $item){
            $item->children = [];
        }

        return $this->sendResponse( $this->return );
    }

    public function store(Request $request)
    {
        $this->checkPermission('02-002','add');

        $code   = (new CostCenterHelper)->get_next_cost_center($request['parent_id']);
        if(!$code['check']){
            return $this->sendError( $code['msg'] , [] );
        }

        $insert                 = $request->all();
        $insert['cost_center_code'] = $code['new_code'];
        $insert['active']       = 1;
        $insert['add_user']     = auth()->user()->id;
        // return $this->sendResponse( $insert , trans('main.add_success') );
        $validator              = validator()->make( $insert , CostCenter::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id']     = CostCenter::add_cost_center($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }
    public function show($lang , $id, Request $request){
        $this->checkPermission('02-002','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-002' , $lang)->sub_title ?? '';
        $this->return['item']           = CostCenter::get_cost_center($id , $lang);

        return $this->sendResponse( $this->return , [] );


    }

    public function update($lang , $id, Request $request)
    {
        $this->checkPermission('02-002','edit');


        $update     = $request->all();

        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('cost_center')->ignore($id,'cost_center_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('cost_center')->ignore($id,'cost_center_id'),
            ],
            'cost_center_code' => [
                'string',
                Rule::unique('cost_center')->ignore($id,'cost_center_id'),
            ]
        ];
        $validator  = validator()->make( $update  , $update_rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        unset($update['_method'] , $update['cost_center_id'] , $update['account_code'] , $update['active'], $update['isOpen']);
//        if( !(new CostCenterHelper)->can_edit_or_delete($id) ){
//            unset($update['account_type'] , $update['account_nature'] , $update['level_chars']);
//        }

        CostCenter::update_cost_center($update ,  $id);

        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('02-002','delete');


        if( !(new CostCenterHelper)->can_edit_or_delete($id) ){
            return $this->sendError( trans('error.delete_fails') , [] );
        }

        CostCenter::delete_cost_center($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang , $id){

        $item = CostCenter::find($id);
        if($item->active){

            $this->checkPermission('02-002','delete');


            if( !(new CostCenterHelper)->can_edit_or_delete($id) ){
                return $this->sendError( trans('error.delete_fails') , [] );
            }

            CostCenter::delete_cost_center($id);
            $this->return['active'] = false;

        }else{

            $this->checkPermission('02-002','edit');


            CostCenter::update_cost_center(array('active' => 1 ) , $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }


}
