<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Tafqeet\Tafqeet;
use App\Classes\General\Upload;
use App\Models\Purchases\PurchasesAgent;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Sales\SalesAgent;
use Illuminate\Http\Request;
use App\Classes\Excel\InvoicesExport;
use App\Classes\Finance\ReceiptVoucherHelper;
use App\Classes\Finance\ChequeIncomingHelper;


use App\Models\Finance\ReceiptVoucher;
use App\Models\Finance\AccountTree;
use App\Models\Finance\CostCenter;
use App\Models\Finance\DailyJournal;
use App\Models\Main\ScreenSub;
use App\Models\Main\Bank;
use App\Models\Main\Delegate;
use App\Models\Main\Branch;
use App\Models\Purchases\Supplier;
use App\Models\Sales\Customer;
use App\Models\Finance\Treasury;
use App\Models\Main\Setting;

use DB;
use PDF;
use App;
use App\Classes\General\General;
use Excel;
use Illuminate\Validation\Rule;
use Storage;

class ReceiptVoucherController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('02-007','view');

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 20 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'branch'        => $this->data['current_branch'] ,
            'finance_year'  => $this->data['current_year']
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['items']       = ReceiptVoucher::all_receipt_voucher( $this->filter );


        // if(request()->header('clientID') == '802'){
        //     $this->return['ids'] = [];

        //     $all = ReceiptVoucher::all_receipt_voucher(['lang' => $lang , 'active' => 1 ]);
        //     foreach ($all as $key => $value) {

        //         (new ReceiptVoucherHelper)->generate_journal($value->id);

        //


        //     }

        // }


        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('02-007','add');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['bank']               = Bank::all_banks( array('lang' => $lang , 'active' => 1 ) );
//        $this->return['delegates']          = Delegate::all_delegates( array('lang' => $lang , 'active' => 1 ) );
//        $this->return['suppliers']          = Supplier::all_suppliers( array('lang' => $lang , 'active' => 1 ) );
//        $this->return['customers']          = Customer::all_customers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['purchases_agents']   = PurchasesAgent::all_purchases_agents(array('lang' => $lang, 'active' => 1));
        $this->return['purchases_vendors']  = PurchasesVendor::all_purchases_vendors(array('lang' => $lang, 'active' => 1));
        $this->return['sales_agents']       = SalesAgent::all_sales_agents(array('lang' => $lang, 'active' => 1));
        $this->return['customers']          = Customer::all_customers(array('lang' => $lang, 'active' => 1));
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['treasurys']          = Treasury::all_treasury( ['lang' => $lang , 'active' => 1 , 'user' => auth()->user()->id ] );

        $this->return['voucher_types']      = DB::table('voucher_types')->get();

        return $this->sendResponse( $this->return  );
    }


    public function store($lang , Request $request)
    {
        $this->checkPermission('02-007','add');

        $insert = $request->only(['description', 'action_date', 'voucher_type_id', 'cost_center_id', 'amount',
                                  'delegate_id', 'invoice_type', 'from_type', 'from_account_tree_id',
                                  'from_supplier_id', 'from_customer_id', 'to_type', 'to_account_tree_id',
                                  'to_treasury_id', 'to_bank_id', 'due_date', 'cheque_number',
                                  'document_number', 'purchases_agent_id', 'purchases_vendor_id', 'sales_agent_id']);
        $year   = array_search( date("Y" , strtotime($insert['action_date'])) , $this->data['years'] );
        if($year == ''){
            return $this->sendError( trans("error.finance_year_not_aval"));
        }
        $codes = (new ReceiptVoucherHelper)->get_next_codes($insert['action_date'] , $year , $this->data['current_branch'] );

        if ($insert['from_type'] == 1 || $insert['from_type'] == 2){
            $insert['sales_agent_id'] = 0;
        }elseif ($insert['from_type'] == 3){
            $insert['purchases_agent_id'] = 0;
        }

        $insert_seed = array(
            'finance_year_id'   => $year ,
            'branch_id'         => $this->data['current_branch'] ,
            'description'       => $insert['description'] ,
            'year_ser'          => $codes['year_ser'] ,
            'month_ser'         => $codes['month_ser'] ,
            'branch_ser'        => $codes['branch_ser'] ,
            'action_date'       => $insert['action_date'] ,
            'cost_center_id'    => $insert['cost_center_id'] ?? 0 ,
            'amount'            => $insert['amount'] ?? 0 ,
            'invoice_type'      => $insert['invoice_type'] ?? 2 ,
            'delegate_id'       => $insert['delegate_id'] ?? 0 ,
            'document_number'   => $insert['document_number'] ?? null ,
            // 'voucher_type_id'   => $insert['voucher_type_id'] ?? 0 ,

            'from_type'             => $insert['from_type'] ?? 1 ,
            'from_account_tree_id'  => $insert['from_account_tree_id'] ?? 0 ,
            'from_supplier_id'      => $insert['from_supplier_id'] ?? 0 ,
            'from_customer_id'      => $insert['from_customer_id'] ?? 0 ,


            'to_type'               => $insert['to_type'] ?? 1 ,
            'to_account_tree_id'    => $insert['to_account_tree_id'] ?? 0 ,
            'to_treasury_id'        => $insert['to_treasury_id'] ?? 0 ,
            'to_bank_id'            => $insert['to_bank_id'] ?? 0 ,
            'due_date'              => $insert['due_date'] ?? 0 ,
            'cheque_number'         => $insert['cheque_number'] ?? 0 ,

            'purchases_agent_id'    => $insert['purchases_agent_id'] ?? 0 ,
            'purchases_vendor_id'   => $insert['purchases_vendor_id'] ?? 0 ,
            'sales_agent_id'        => $insert['sales_agent_id'] ?? 0 ,

            'add_user'              => auth()->user()->id
        );


        $validator = validator()->make( $insert_seed , ReceiptVoucher::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }


        DB::beginTransaction();

            $id = ReceiptVoucher::add_receipt_voucher($insert_seed);
            if(isset($request['items']) && is_array($request['items'])){
                foreach($request['items'] as $item){
                    $details_seed = [
                        'receipt_voucher_m_id'  => $id,
                        'document_id'           => $item['document_id'],
                        'amount'                => $item['amount'] ?? 0,
                    ];
                    ReceiptVoucher::add_receipt_voucher_d($details_seed);
                }

            }
            (new ReceiptVoucherHelper)->generate_journal($id);
            (new ReceiptVoucherHelper)->update_related($id , []);

            if($insert['to_type'] == 4)
                (new ChequeIncomingHelper)->generate_from_receipt_vouchers($id);

        DB::commit();


        $this->return['id'] = $id;

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang, $id)
    {
        $this->checkPermission('02-007','view');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? '';
        $this->return['data']               = ReceiptVoucher::get_receipt_voucher($id , $lang);
//        $this->return['delegates']          = Delegate::all_delegates( array('lang' => $lang , 'active' => 1 ) );
//        $this->return['suppliers']          = Supplier::all_suppliers( array('lang' => $lang , 'active' => 1 ) );
//        $this->return['customers']          = Customer::all_customers( array('lang' => $lang , 'active' => 1 ) );
        $this->return['purchases_agents']   = PurchasesAgent::all_purchases_agents(array('lang' => $lang, 'active' => 1));
        $this->return['purchases_vendors']  = PurchasesVendor::all_purchases_vendors(array('lang' => $lang, 'active' => 1));
        $this->return['sales_agents']       = SalesAgent::all_sales_agents(array('lang' => $lang, 'active' => 1));
        $this->return['customers']          = Customer::all_customers(array('lang' => $lang, 'active' => 1));
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['cost_centers']       = CostCenter::active_cost_centers($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['treasurys']          = Treasury::all_treasury( ['lang' => $lang , 'active' => 1 , 'user' => auth()->user()->id ] );
        $this->return['bank']               = Bank::all_banks( array('lang' => $lang , 'active' => 1 ) );
        $this->return['attachments']        = ReceiptVoucher::get_attachs($id);
        $this->return['voucher_types']      = DB::table('voucher_types')->get();
        $this->return['details']            = ReceiptVoucher::get_receipt_voucher_d($id , $lang);


        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


    public function update($lang , $id, Request $request)
    {
        $this->checkPermission('02-007','edit');

        $item       = ReceiptVoucher::get_receipt_voucher($id);
        $update     = $request->only(['description', 'action_date', 'cost_center_id', 'amount' ,'voucher_type_id',
                                  'delegate_id', 'invoice_type', 'from_type', 'from_account_tree_id',
                                  'from_supplier_id', 'from_customer_id', 'to_type', 'to_account_tree_id',
                                  'to_treasury_id', 'to_bank_id', 'due_date', 'cheque_number',
                                  'document_number', 'purchases_agent_id', 'purchases_vendor_id', 'sales_agent_id']);

        $year   = array_search( date("Y" , strtotime($update['action_date'])) , $this->data['years'] );
        if($year == '' || $year != $item->finance_year_id){
            return $this->sendError( trans("error.finance_year_not_aval"));
        }

        $update_rules = [
            'document_number' => [
                Rule::unique('receipt_vouchers')->ignore($id,'receipt_voucher_id'),
            ]
        ];
        $validator = validator()->make( $update , $update_rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        DB::beginTransaction();
            $old  = ReceiptVoucher::get_receipt_voucher_d($id , $lang)->pluck('document_id')->toArray();
            ReceiptVoucher::update_receipt_voucher($update ,  $id);
            if(isset($request['deleted_items']) && is_array($request['deleted_items'])){
                foreach ($request['deleted_items'] as $deleted_item){
                    DB::table('receipt_vouchers_d')->where('receipt_voucher_d_id', $deleted_item['d_id'])->delete();
                }
            }
            if(isset($request['items']) && is_array($request['items'])){
                foreach($request['items'] as $item){
                    if($item['d_id'] == 0){
                        $details_seed = [
                            'receipt_voucher_m_id'  => $id,
                            'document_id'           => $item['document_id'],
                            'amount'                => $item['amount'] ?? 0,
                        ];
                        ReceiptVoucher::add_receipt_voucher_d($details_seed);

                    }elseif($item['d_id'] > 0){
                        $updata_detail = [
                            'document_id'           => $item['document_id'],
                            'amount'                => $item['amount'] ?? 0,
                        ];
                        DB::table('receipt_vouchers_d')->where('receipt_voucher_d_id', $item['d_id'])->update($updata_detail);

                    }
                }

            }
            (new ReceiptVoucherHelper)->generate_journal($id);
            (new ReceiptVoucherHelper)->update_related($id , $old);

        DB::commit();

        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('02-007','delete');

        $master = ReceiptVoucher::get_receipt_voucher($id);
        DB::beginTransaction();
            ReceiptVoucher::delete_receipt_voucher($id);
            (new ReceiptVoucherHelper)->generate_journal($id);
            (new ReceiptVoucherHelper)->update_related($id);
        DB::commit();


        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang , $id){

        $item = ReceiptVoucher::find($id);
        if($item->receipt_voucher_active){

            $this->checkPermission('02-007','delete');


            if( !(new ReceiptVoucherHelper)->can_edit_or_delete($id) ){
                return $this->sendError( trans('error.delete_fails') , [] );
            }


            DB::beginTransaction();
                ReceiptVoucher::delete_receipt_voucher($id);
                (new ReceiptVoucherHelper)->generate_journal($id);
                (new ReceiptVoucherHelper)->update_related($id);
            DB::commit();



            $this->return['active'] = false;

        }else{

            $this->checkPermission('02-007','edit');



            DB::beginTransaction();
                ReceiptVoucher::update_receipt_voucher(array('receipt_voucher_active' => 1 ) , $id);
                (new ReceiptVoucherHelper)->generate_journal($id);
                (new ReceiptVoucherHelper)->update_related($id);
            DB::commit();

            $this->return['active'] = true;
        }


        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function export_data($lang , $id , Request $request)
    {

        $this->checkPermission('02-007','print');

        $this->return['lang']           = 'ar';
        $this->return['print_title']    = ScreenSub::get_screen_sub_by_screen_code('02-007' , $lang)->sub_title ?? 'Receipt Voucher';
        $this->return['data']           = ReceiptVoucher::get_receipt_voucher($id, $lang);
        $this->return['data']->tafqeet  = Tafqeet::inArabic((round($this->return['data']->amount , 2)));
        $this->return['data']->tafqeet_en = ( new General )->numberToText('en', $this->return['data']->amount);

        $this->return['branch_data']    = Branch::get_branch($this->return['data']->branch_id);
        $this->return['print_right']    = $this->return['branch_data']->print_label_ar ?? '';
        $this->return['print_left']     = $this->return['branch_data']->print_label_en ?? '';
        $this->return['logo']           = $this->return['branch_data']->branch_image;


        $temp_name                 = Setting::get_main_setting_by_code('receipt_voucher_print')->value ?? 'print';
        $print_temp                = 'Finance/receipt_voucher/.'.$temp_name;


        switch (@$request['type']) {
            case 'excel':
                $this->return['logo']     = public_path().$this->return['logo'];
                $export = new InvoicesExport($this->return , $print_temp );
                return Excel::download($export, 'receipt_voucher.xlsx');
            break;
            case 'pdf':
                $this->return['logo']     = public_path().$this->return['logo'];
                $pdf = PDF::loadView($print_temp , array('data' => $this->return ));
                return $pdf->stream();

            break;
            case 'image':
                $this->return['logo']     = public_path().$this->return['logo'];
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp  ,array('data' => $this->return ));
                return $image->stream();

            break;
            case 'print':
                $this->return['logo'] = url($this->return['logo']);
                return view($print_temp )->with('data' , $this->return);
            break;
            default:
                $this->return['logo'] = url($this->return['logo']);
                return $this->sendResponse( $this->return , '' );
            break;

        }

    }

    public function add_attach($lang , $id , Request $request){

        $upload = new Upload;
        $check  = $upload->uploadFile($request['file_path'] , 'receipt_voucher' );
        if(!$check['check'])
            return $this->sendError( trans('error.add_fails') , $check['msg'] );

        $this->return['id'] = DB::table('receipt_voucher_attachments')->insertGetId( [
            'receipt_voucher_id'    => $id ,
            'file_name'             => $request['file_name'] ?? date('Y-m-d H:i:s') ,
            'file_path'             => $check['url']  ,
            'file_ext'              => $check['extension']  ,
            'add_user'              => auth()->user()->id
        ]);

        return $this->sendResponse( $this->return , '' );
    }

    public function download_attach($lang , $id){

        $file = DB::table('receipt_voucher_attachments')
            ->where('attachment_id' , $id)
            ->first();

        return response()->file(public_path().$file->file_path);

    }

    public function get_attachs($lang , $id){
        $this->return['data'] = ReceiptVoucher::get_attachs($id);
        return $this->sendResponse( $this->return , '' );

    }

    public function delete_attach($lang , $id){

        $file = DB::table('receipt_voucher_attachments')
            ->where('attachment_id' , $id)
            ->first();

        DB::table('receipt_voucher_attachments')
            ->where('attachment_id' , $id)
            ->delete();

        if(Storage::exists($file->file_path)){
            Storage::delete($file->file_path);
        }
        return $this->sendResponse( $this->return , '' );
    }
}
