<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Classes\Finance\TreasuryHelper;

use App\Models\Finance\Treasury;
use App\Models\Finance\AccountTree;
use App\Models\Main\ScreenSub;
use App\Models\User;



class TreasuryController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-006' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? null ,
            'word'        => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang)->sub_title ?? '';
        $this->return['items']       = Treasury::all_treasury( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-006' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang);
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['users']              = User::all_users( array( 'user_active' => 1 , 'lang' => $lang ) );

        return $this->sendResponse( $this->return  );
    }

    public function store(Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'create permission needed #02-006' , [] , 200 );
        }

        $insert                 = $request->only(['treasury_name_en', 'treasury_name_ar', 'users',
                                                  'account_tree_id', 'first_balance', 'first_balance_date',
                                                  'first_balance_type']);
        $insert['add_user']     = auth()->user()->id;
        $insert['users']        = ( is_array($insert['users'] ?? []) ) ? implode(',', $insert['users'] ?? [] ) : $insert['users'] ;
        $validator              = validator()->make( $insert , Treasury::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id']     = Treasury::add_treasury($insert);
        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id, Request $request){
        if(!@in_array('1', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-006' , [] , 200 );
        }
        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-006' , $lang)->sub_title ?? '';
        $this->return['item']           = Treasury::get_treasury($id);
        $this->return['users']          = User::all_users( array( 'user_active' => 1 , 'lang' => $lang ) );
        $this->return['account_trees']  = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));

        return $this->sendResponse( $this->return , [] );

    }

    public function update($lang , $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-006' , [] , 200 );
        }

        $update         = $request->only(['treasury_name_en', 'treasury_name_ar', 'account_tree_id']);
        $update['users']= ( is_array($request['users'] ?? []) ) ? implode(',', $request['users'] ?? [] ) : $request['users'] ;
        $rules          = collect(Treasury::$rules)->only('treasury_name_ar' , 'treasury_name_en')->all() ;
        $validator      = validator()->make( $update  , $rules);
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        Treasury::update_treasury($update ,  $id);
        return $this->sendResponse( $this->return , trans('main.update_success') );

    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'delete permission needed #02-006' , [] , 200 );
        }

        if( !(new TreasuryHelper)->can_edit_account_code($id) ){
            return $this->sendError( trans('error.delete_fails') , [] );
        }

        Treasury::delete_treasury($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['02-006'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-006' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            Treasury::update_treasury(array('treasury_order' => $key ),  $value['id']);
        }

        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){

        $item = Treasury::find($id);
        if($item->treasury_active){

            if(!@in_array('4', $this->data['mypermissions']['02-006'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-006' , [] , 200 );
            }

            Treasury::delete_treasury($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['02-006'][0]->permission) ){
                return $this->sendError( 'update permission needed #02-006' , [] , 200 );
            }

            Treasury::update_treasury(array('treasury_active' => 1 ) , $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }


}
