<?php

namespace App\Http\Controllers\API\V1;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use App\Classes\General\General;
use Illuminate\Http\Request;
use App\Models\User;


class GeneralController extends BaseController
{

    public function get_my_profile($lang)
    {

        $data       = (new General)->get_user_profile(auth()->user()->id, $lang);
        return $this->sendResponse($data, '');
    }
    public function get_home_data($lang)
    {
        $data       = (new General)->home_data(auth()->user()->id, $lang);

        return $this->sendResponse($data, '');
    }
    public function get_profile_data($lang)
    {
        $data       = (new General)->profile_data(auth()->user()->id, $lang);
        return $this->sendResponse($data, '');
    }

    public function update_profile($lang, Request $request)
    {
        $input  = request()->input();
        $update = array();

        if(isset($request['user_full_name'])){$update['user_full_name'] = $input['user_full_name'];}
        if(isset($request['sales_agent_id'])){$update['sales_agent_id'] = $input['sales_agent_id'];}
        if(isset($request['default_branch'])){$update['default_branch'] = $input['default_branch'];}
        if(isset($request['default_year'])){$update['default_year'] = $input['default_year'];}

        if(isset($request['image_url']) && strlen($request['image_url']) > 100){
            $upload = new Upload;
            $check  = $upload->uploadBase64Image($request['image_url'], 'profile_images', 300, 300);
            if(!$check['check'])
                return $this->sendError(trans('error.add_fails'), $check['msg']);
            else
                $seed['image_url'] = $check['url'];
        }

        if(count( $update ) > 0){
            User::update_user($update, auth()->user()->id);
        }

        return $this->sendResponse((new General)->get_user_profile(auth()->user()->id, $lang));
    }
}
