<?php

namespace App\Http\Controllers\API\V1\Inventory;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Classes\Inventory\CategoryHelper;
use App\Models\Main\ScreenSub;
use App\Models\Inventory\Category;
use Illuminate\Validation\Rule;
use DB;
class CategoryController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        $this->checkPermission('03-002','view');

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? null ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'parent'        => $request['parent'] ?? null ,
            'category_type' => $request['category_type'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-002', $lang)->sub_title ?? '';
        $this->return['items']       = Category::all_categorys($this->filter);

        //check if have elevators module
        $module_ids = DB::table('screen_subs')
        ->where(DB::raw('SUBSTRING(screen_code, 1, 2)'), '=', '10')
        ->pluck('screen_sub_id')->toArray();
        $permissions = DB::table('user_permissions')
        ->leftjoin('screen_subs' , 'user_permissions.screen_sub_id' , '=' , 'screen_subs.screen_sub_id')
        ->where('user_permissions.user_id' , auth()->user()->id)
        ->whereIn('user_permissions.screen_sub_id' , $module_ids)
        ->where('user_permissions.permission' , "<>" , "[]")->count();
        if($permissions > 0){
            $this->return['service_type_input'] = true;
        }else{
            $this->return['service_type_input'] = false;

        }
        $this->return['sub_categorys'] = Category::all_categorys(array('lang' => $lang, 'category_type' => 0, 'active' => '1'));

        foreach($this->return['items'] as $item){
            $item->children = [];
        }

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('03-002','add');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-002', $lang)->sub_title ?? '';
        $this->return['categorys']   = Category::all_categorys(array('lang' => $lang, 'category_type' => 1, 'active' => '1'));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('03-002','add');

        $insert             = $request->only(['name_en', 'name_ar', 'category_type', 'parent_id', 'service_type']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, Category::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        if($insert['category_type'] != 1){
            $insert['category_type'] = 0;
        }
        $this->return['id'] = Category::add_category($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('03-002','view');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-002', $lang)->sub_title ?? '';
        $this->return['data']        = Category::get_category($id, $lang);
        $this->return['categorys']   = Category::all_categorys(array('lang' => $lang, 'category_type' => 1, 'active' => '1'));

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('03-002','edit');

        if(!(new CategoryHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update    = $request->only(['name_en', 'name_ar', 'category_type', 'parent_id', 'service_type']);
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('categorys')->ignore($id,'category_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('categorys')->ignore($id,'category_id'),
            ]
        ];
        $validator = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        Category::update_category($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('03-002','delete');

        if(!(new CategoryHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        Category::delete_category($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = Category::find($id);

        if($item->category_active){
            $this->checkPermission('03-002','delete');

            if(!(new CategoryHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            Category::delete_category($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('03-002','edit');

            if(!(new CategoryHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            Category::update_category(array('category_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function get_sub_categorys($lang, $category_id)
    {
        $this->checkPermission('03-002','view');

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-002', $lang)->sub_title ?? '';
        $this->return['data']        = Category::get_sub_categorys($category_id, $lang);

        return $this->sendResponse($this->return);
    }
}
