<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Models\Main\Locations;
use App\Models\Main\ScreenSub;



class LocationController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['items']       = Locations::get_all( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {

        $insert    = $request->only(['name_en', 'name_ar']);
        $validator = validator()->make( $insert , Locations::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        $insert['add_user'] = auth()->user()->id;
        $this->return['id'] = Locations::add_location($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {

        $this->return['data']               = Locations::find($id);

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {

        $update     = $request->only(['name_en', 'name_ar']);
        $validator  = validator()->make( $update , Locations::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        Locations::update_location($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {

        Locations::delete_location($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function toggle_active($lang , $id){
        $item = Locations::find($id);
        if($item->active){

            Locations::delete_location($id);
            $this->return['active'] = false;

        }else{

            Locations::update_location(array('active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
