<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;


use App\Models\Main\ScreenSub;
use App\Models\Main\Partner;
use App\Models\Finance\AccountTree;

class PartnerController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-012' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null

        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-012' , $lang)->sub_title ?? '';
        $this->return['items']       = Partner::all_partners( $this->filter  );

        return $this->sendResponse( $this->return );
    }


    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-012' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-012' , $lang)->sub_title ?? '';
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));

        return $this->sendResponse( $this->return  );
    }

    public function store(Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-012' , [] , 200 );
        }


        $insert             = $request->only(['name_en', 'name_ar', 'account_tree_id']);
        $insert['add_user'] = auth()->user()->id;
        $validator          = validator()->make( $insert , Partner::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }


        $this->return['id'] = Partner::add_partner($insert);


        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-012' , [] , 200 );
        }
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-012' , $lang)->sub_title ?? '';
        $this->return['account_trees']      = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['data']               = Partner::get_partner($id);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }


    public function edit($id)
    {
        //
    }


    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-012' , [] , 200 );
        }

        $update    = $request->only(['name_en', 'name_ar', 'account_tree_id']);

        $validator = validator()->make( $request->all() , Partner::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        Partner::update_partner($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }


    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-012' , [] , 200 );
        }
        Partner::delete_partner($id);
        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-012'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-012' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            Partner::update_partner(array('partner_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = Partner::find($id);
        if($item->partner_active){

            if(!@in_array('4', $this->data['mypermissions']['01-012'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-012' , [] , 200 );
            }

            Partner::delete_partner($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-012'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-012' , [] , 200 );
            }

            Partner::update_partner(array('partner_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );

    }
}
