<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use Illuminate\Http\Request;

use App\Models\Main\ScreenMain;
use App\Models\Main\ScreenCat;
use App\Models\Main\ScreenSub;



class ScreenCatController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-002' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'main'        => $request['main'] ?? null ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-002' , $lang)->sub_title ?? '';
        $this->return['items']       = ScreenCat::all_screen_cats( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-002' , [] , 200 );
        }

        $this->return['screen_name']  = ScreenSub::get_screen_sub_by_screen_code('01-002' , $lang)->sub_title ?? '';
        $this->return['mains']        = ScreenMain::all_screen_mains( array('lang' => $lang  , 'active' => 1 ) );

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-002' , [] , 200 );
        }


        $insert             = $request->only(['screen_cat_title_en', 'screen_cat_title_ar', 'screen_main_id']);
        $insert['add_user'] = auth()->user()->id;
        $validator          = validator()->make( $insert , ScreenCat::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = ScreenCat::add_screen_cat($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-002' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-002' , $lang)->sub_title ?? '';
        $this->return['data']               = ScreenCat::find($id);
        $this->return['mains']              = ScreenMain::all_screen_mains( array('lang' => $lang  , 'active' => 1 ) );

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-002' , [] , 200 );
        }

        $update     = $request->only(['screen_cat_title_en', 'screen_cat_title_ar', 'screen_main_id']);
        $validator  = validator()->make( $update , ScreenCat::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        ScreenCat::update_screen_cat($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-002' , [] , 200 );
        }

        ScreenCat::delete_screen_cat($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-002'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-002' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            ScreenCat::update_screen_cat(array('screen_cat_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = ScreenCat::find($id);
        if($item->screen_cat_active){

            if(!@in_array('4', $this->data['mypermissions']['01-002'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-002' , [] , 200 );
            }

            ScreenCat::delete_screen_cat($id);
            $this->return['active'] = false;
        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-002'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-002' , [] , 200 );
            }

            ScreenCat::update_screen_cat(array('screen_cat_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
