<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Classes\General\Upload;
use Illuminate\Http\Request;

use App\Models\Main\ScreenMain;
use App\Models\Main\ScreenCat;
use App\Models\Main\ScreenSub;

use Illuminate\Support\Facades\DB;

class ScreenSubController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-003' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'main'        => $request['main'] ?? null ,
            'cat'         => $request['cat'] ?? null ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-003' , $lang)->sub_title ?? '';
        $this->return['items']       = ScreenSub::all_screen_subs( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-003' , [] , 200 );
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-003' , $lang)->sub_title ?? '';
        $this->return['cats']           = ScreenCat::all_screen_cats( array('lang' => $lang  , 'active' => 1 ) );

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-003' , [] , 200 );
        }

        $insert                 = $request->only(['screen_sub_title_en', 'screen_sub_title_ar', 'screen_cat_id', 'screen_code', 'actions', 'url']);
        $insert['add_user']     = auth()->user()->id;
        $insert['screen_code']  = $this->get_new_code($insert['screen_cat_id']);
        $validator              = validator()->make( $insert , ScreenSub::$rules );

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = ScreenSub::add_screen_sub($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-003' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-003' , $lang)->sub_title ?? '';
        $this->return['data']               = ScreenSub::find($id);
        $this->return['cats']               = ScreenCat::all_screen_cats( array('lang' => $lang  , 'active' => 1 ) );

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-003' , [] , 200 );
        }

        $update     = $request->only(['screen_sub_title_en', 'screen_sub_title_ar', 'screen_cat_id', 'screen_code', 'actions', 'url']);
        $rules      = ScreenSub::$rules;
        unset($rules['screen_code'] , $rules['url'] ,$rules['actions']);
        $validator  = validator()->make( $update , $rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        ScreenSub::update_screen_sub($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-003' , [] , 200 );
        }

        ScreenSub::delete_screen_sub($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-003'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-003' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            ScreenSub::update_screen_sub(array('screen_sub_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    protected function get_new_code($cat){
        $main   = ScreenCat::get_screen_cat($cat);
        $last   = DB::table('screen_subs')
            ->join('screen_cats' , 'screen_subs.screen_cat_id' , '=' , 'screen_cats.screen_cat_id')
            ->where('screen_main_id' , $main->screen_main_id )
            ->orderBy('screen_sub_id' , 'desc')
            ->first();
        if($last == null){
            if(strlen($main->screen_main_id) == 2){
                $last = $main->screen_main_id."-"."000";
            }elseif(strlen($main->screen_main_id) == 1){
                $last = "0".$main->screen_main_id."-"."000";
            }
        }
        return explode('-', $last->screen_code)[0]."-".str_pad( intval( explode('-', $last->screen_code)[1] ) + 1  , 3 , '0' , STR_PAD_LEFT) ;
    }

    public function toggle_active($lang , $id){
        $item = ScreenSub::find($id);
        if($item->screen_sub_active){

            if(!@in_array('4', $this->data['mypermissions']['01-003'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-003' , [] , 200 );
            }

            ScreenSub::delete_screen_sub($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-003'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-003' , [] , 200 );
            }

            ScreenSub::update_screen_sub(array('screen_sub_active' => 1 ),  $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
