<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Sales\SalesArea;
use Illuminate\Http\Request;
use App\Classes\Sales\SalesAreaHelper;
use App\Models\Main\ScreenSub;
use Illuminate\Validation\Rule;

class SalesAreaController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('view permission needed #06-004', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-004', $lang)->sub_title ?? '';
        $this->return['items']       = SalesArea::all_sales_areas($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('create permission needed #06-004', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-004', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('create permission needed #06-004', [], 200);
        }

        $insert             = $request->only(['name_en', 'name_ar', 'location']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, SalesArea::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = SalesArea::add_sales_area($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('show permission needed #06-004', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-004', $lang)->sub_title ?? '';
        $this->return['data']        = SalesArea::get_sales_area($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('show permission needed #06-004', [], 200);
        }

        if(!(new SalesAreaHelper())->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update     = $request->only(['name_en', 'name_ar', 'location']);
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('sales_areas')->ignore($id,'sales_area_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('sales_areas')->ignore($id,'sales_area_id'),
            ]
        ];
        $validator  = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        SalesArea::update_sales_area($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-004'][0]->permission)){
            return $this->sendError('delete permission needed #06-004', [], 200);
        }

        if(!(new SalesAreaHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        SalesArea::delete_sales_area($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = SalesArea::find($id);

        if($item->sales_area_active){
            if(!@in_array('4', $this->data['mypermissions']['06-004'][0]->permission)){
                return $this->sendError('update permission needed #06-004', [], 200);
            }

            if(!(new SalesAreaHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            SalesArea::delete_sales_area($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['06-004'][0]->permission)){
                return $this->sendError('update permission needed #06-004', [], 200);
            }

            if(!(new SalesAreaHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            SalesArea::update_sales_area(array('sales_area_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
