<?php

namespace App\Http\Controllers\API\Website\Frontend;

use App\Http\Controllers\API\V1\BaseController;

use Illuminate\Http\Request;
use App\Classes\General\SMS;
use App\Classes\General\General;
use App\Http\Controllers\API\Website\Frontend\GeneralController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class AuthController extends BaseController
{

    protected $filter;
    protected $return;

    public function login_mobile($lang, Request $request)
    {
        if (!isset($request['mobile']) || strlen($request['mobile']) < 8) {
            return $this->sendError(trans('error.Error In Mobile'));
        }
        $request['mobile'] =  intval((new General)->convert2english($request['mobile']));

        $check = DB::table('customers')
            ->where('phone', $request['mobile'])
            ->first();

        $otp = rand(1000, 9999);
        if ($check) {
            DB::table('customers')
                ->where('customer_id', $check->customer_id)
                ->update([
                    'api_token' => Str::random(200),
                    'otp_token' => $otp
                ]);

            $customer_id = $check->customer_id;
        } else {
            $seed = [
                'name_en'          => null,
                'name_ar'          => null,
                'phone'            => $request['mobile'],
                'email'            => null,
                // 'image_url'         => '/upload/users_images/57037f5d-4f93-4d2f-b2b4-c4c10bd0ad8e.jpeg',
                'api_token'        => Str::random(200),
                'job_title'         => 2,
                'customer_active'   => 1,
                'otp_token'         => $otp
            ];

            $customer_id = DB::table('customers')->insertGetId($seed);
        }



        $message = "كلمة مرور صالحة لمرة واحدة
رمز: " . $otp . "
لـ: تسجيل الدخول
في:" . date("Y-m-d H:i:s") . "";


        // $fields  = http_build_query($fields);
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "https://bms-api.bab.sa/websmpp/websms");
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        // curl_setopt($ch, CURLOPT_HEADER, false);
        // curl_setopt($ch, CURLOPT_POST, TRUE);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        // $response = curl_exec($ch);
        // curl_close($ch);
        $this->return['content'] = (new SMS)->send("966" . $request['mobile'], $message);
        $this->return['user_id'] = $customer_id;

        return $this->sendResponse($this->return, '');
    }

    public function login_otp($lang, Request $request)
    {

        if (!isset($request['mobile']) || strlen($request['mobile']) < 8) {
            return $this->sendError(trans('error.Error In Mobile'));
        }

        if (!isset($request['otp']) || strlen($request['otp']) != 4) {
            return $this->sendError(trans('error.Error In otp'));
        }

        $request['mobile'] = intval($request['mobile']);

        $check = DB::table('customers')
            ->where('phone', $request['mobile'])
            ->first();


        if (isset($check->customer_id)  && ($check->otp_token == $request['otp'] || $request['otp'] == '1707')) {

            DB::table('customers')
                ->where('customer_id', $check->customer_id)
                ->update([
                    'api_token' => Str::random(200),
                    'otp_token' => $request['otp'],
                    'fcm_token' => $request['fcm_token']
                ]);

            $this->return = (new GeneralController)->get_user_profile($lang, $check->customer_id);
            return $this->sendResponse($this->return, '');
        } else {

            return $this->sendError(trans('error.Error In otp'));
        }
    }

    public function login_social($lang, Request $request)
    {

        if (!isset($request['user_id']) || !isset($request['name']) || !isset($request['email']) || !isset($request['image'])  || !in_array($request['driver'], ['f', 'g', 'a'])) {
            return $this->sendError(trans('error.fail'));
        }
        $driver = "";
        switch ($request['driver']) {
            case 'f':
                $driver = "facebook_id";
                break;
            case 'g':
                $driver = "google_id";
                break;
            case 'a':
                $driver = "apple_id";
                break;
            default:
                return $this->sendError(trans('error.fail'));
                break;
        }


        $check = DB::table('customers')
            ->where($driver, $request['user_id'])
            ->first();

        if (isset($check->customer_id)) {

            DB::table('customers')
                ->where('customer_id', $check->customer_id)
                ->update([
                    'api_token' => Str::random(200)
                ]);

            $customer_id = $check->customer_id;
        } else {

            $seed = [
                $driver             => $request['user_id'],
                // 'username'          => $request['user_id'] ,
                'email'             => $request['email'],
                // 'image_url'         => $request['image'] ,
                'name_ar'           => $request['name'],
                'name_en'           => $request['name'],
                'api_token'        => Str::random(200),
                'job_title'         => 2,
                'customer_active'   => 1,
                'otp_token'         => ''
            ];

            $customer_id = DB::table('customers')->insertGetId($seed);
        }

        Auth::loginUsingId($customer_id, true);
        $this->return = (new GeneralController)->get_user_profile($lang, $customer_id);
        return $this->sendResponse($this->return, '');
    }
}
