<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AssetsDeprecating extends Model
{
    protected $primaryKey = 'assets_deprecating_id';

    public static $main_table = 'assets_deprecating';

    public static $rules = array(

    );

    public static function all_assets_deprecating($params = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_deprecating.asset_m_id')
        ->orderBy('assets_deprecating_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                assets_deprecating_id as id  ,
                assets_m.name_'.$params['lang'].' as name ,
                assets_m.asset_code ,
                assets_deprecating.asset_m_id ,
                assets_deprecating.doc_date,
                assets_deprecating.doc_number,
                assets_deprecating.notes,
                assets_deprecating.add_user ,
                assets_deprecating.add_date
            ');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('assets_m.name_'.$params['lang'] , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('assets_m.asset_code' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_deprecating($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_deprecating.asset_m_id');

        if($lang != null){
            $query->selectRaw('
                assets_deprecating.assets_deprecating_id as id  ,
                assets_m.name_'.$lang.' as name ,
                assets_m.asset_code ,
                assets_deprecating.asset_m_id ,
                assets_deprecating.doc_date,
                assets_deprecating.doc_number,
                assets_deprecating.notes,
                assets_deprecating.add_user ,
                assets_deprecating.add_date
            ');
        }

        $data = $query->first();
        return $data;

    }


    public static function add_assets_deprecating($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_assets_deprecating($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('assets_deprecating_id' , $id )->update($seed);
    }

}
