<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AssetsSelling extends Model
{
    protected $primaryKey = 'assets_selling_id';

    public static $main_table = 'assets_selling';

    public static $rules = array(

    );

    public static function all_assets_selling($params = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_selling.asset_m_id')
        ->orderBy('assets_selling_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                assets_selling_id as id  ,
                assets_m.name_'.$params['lang'].' as name ,
                assets_m.asset_code ,
                assets_selling.asset_m_id ,
                assets_selling.doc_date,
                assets_selling.sale_type,
                assets_selling.exchange_price,
                assets_selling.value_added,
                assets_selling.rec_value_added,
                assets_selling.payment_method,
                assets_selling.account_number,
                assets_selling.doc_number,
                assets_selling.notes,
                assets_selling.add_user ,
                assets_selling.add_date
            ');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('assets_m.name_'.$params['lang'] , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('assets_m.asset_code' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_selling($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_selling.asset_m_id')
        ->where('assets_selling.assets_selling_id',$id);

        if($lang != null){
            $query->selectRaw('
                assets_selling.assets_selling_id as id  ,
                assets_m.name_'.$lang.' as name ,
                assets_m.asset_code ,
                assets_selling.asset_m_id ,
                assets_selling.doc_date,
                assets_selling.sale_type,
                assets_selling.exchange_price,
                assets_selling.value_added,
                assets_selling.rec_value_added,
                assets_selling.payment_method,
                assets_selling.account_number,
                assets_selling.doc_number,
                assets_selling.notes,
                assets_selling.add_user ,
                assets_selling.add_date
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function get_assets_selling_attachments($lang,$m_id){
        $query =  DB::table('assets_selling_attachments')
            ->where('assets_selling_id' , $m_id);

        if($lang != null){
            $query->selectRaw('
                assets_selling_attachments.attachment_id as id ,
                assets_selling_attachments.assets_selling_id,
                assets_selling_attachments.file_name ,
                assets_selling_attachments.file_url as file_path,
                assets_selling_attachments.add_user ,
                assets_selling_attachments.add_date
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_assets_selling($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_selling_attachments($seed)
    {
        return DB::table('assets_selling_attachments')->insertGetId($seed);
    }
    public static function delete_selling_attachments($id)
    {
        return DB::table('assets_selling_attachments')->where('attachment_id' , $id)->delete();
    }

    public static function update_assets_selling($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('assets_selling_id' , $id )->update($seed);
    }

}
