<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AssetsSettings extends Model
{
    protected $primaryKey = 'setting_id';

    public static $main_table = 'assets_settings';

    public static $rules = array(
        'loss_acc_id'       => 'required|integer',
        'profit_acc_id'     => 'required|integer',
        'create_purchase'   => 'required|integer',
        'create_journal'    => 'required|integer',
        'show_journal'      => 'required|integer',
    );

    public static function all_assets_settings($params = null)
    {
        $query =  DB::table(self::$main_table);

        if($params['lang'] != null){
            $query->selectRaw('
                setting_id as id,
                loss_acc_id,
                profit_acc_id,
                create_purchase,
                create_journal,
                show_journal,
                add_user,
                add_date,
                active
            ');
        }

        if(isset($params['active']))
            $query->where('active' , $params['active']);

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_assets_settings($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('setting_id' , $id);

        if($lang != null){
            $query->selectRaw('
                setting_id as id,
                loss_acc_id,
                profit_acc_id,
                create_purchase,
                create_journal,
                show_journal,
                add_user,
                add_date,
                active
            ');
        }

        $data = $query->first();
        return $data;

    }

    // public static function add_assets_settings($seed)
    // {
    //     return DB::table(self::$main_table)->insertGetId($seed);
    // }

    public static function update_assets_settings($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('setting_id' , $id )->update($seed);
    }

    // public static function delete_assets_settings($id)
    // {
    //     return DB::table(self::$main_table)->where('setting_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    // }



}
