<?php

namespace App\Models\Assets;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class DepreciationCalculate extends Model
{
    protected $primaryKey = 'dep_calc_m_id';

    public static $main_table = 'assets_dep_calc_m';

    public static $rules = array(

    );

    public static function all_depr_calculations_m($params = null)
    {
        $query =  DB::table(self::$main_table)
        ->leftJoin('finance_years','finance_years.finance_year_id','assets_dep_calc_m.finance_year_id')
        ->leftJoin('assets_dep_calc_d', 'assets_dep_calc_m.dep_calc_m_id', 'assets_dep_calc_d.dep_calc_m_id')
        ->groupBy('assets_dep_calc_m.dep_calc_m_id')
        ;
        if($params['lang'] != null){
            $query->selectRaw('
                assets_dep_calc_m.dep_calc_m_id as id,
                assets_dep_calc_m.finance_year_id ,
                finance_years.name as year,
                assets_dep_calc_m.branch_id,
                assets_dep_calc_m.action_date,
                assets_dep_calc_m.asset_category_id ,
                assets_dep_calc_m.assets_ids ,
                assets_dep_calc_m.deprecation_from,
                assets_dep_calc_m.deprecation_to,
                sum(assets_dep_calc_d.total_deprecation) as total_deprecation,
                assets_dep_calc_m.add_user,
                assets_dep_calc_m.add_date

            ');
        }
        if(isset($params['action_date']) && strlen($params['action_date']) >  0){
            $query->where('assets_dep_calc_m.action_date',$params['action_date']);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }
    public static function get_depr_calculations_m($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
        ->where('assets_dep_calc_m.dep_calc_m_id',$id);

        if($lang != null){
            $query->selectRaw('
                assets_dep_calc_m.dep_calc_m_id as id,
                assets_dep_calc_m.finance_year_id ,
                assets_dep_calc_m.branch_id ,
                assets_dep_calc_m.action_date,
                assets_dep_calc_m.asset_category_id ,
                assets_dep_calc_m.assets_ids ,
                assets_dep_calc_m.deprecation_from,
                assets_dep_calc_m.deprecation_to,
                assets_dep_calc_m.add_user,
                assets_dep_calc_m.add_date
            ');
        }

            $data = $query->first();

        return $data;
    }
    public static function get_depr_calculations_d($id , $lang = null)
    {
        $query =  DB::table('assets_dep_calc_d')
        ->leftJoin('assets_dep_calc_m', 'assets_dep_calc_m.dep_calc_m_id', 'assets_dep_calc_d.dep_calc_m_id')
        ->leftJoin('assets_m', 'assets_m.asset_m_id', 'assets_dep_calc_d.asset_m_id')
        ->where('assets_dep_calc_d.dep_calc_m_id',$id);

        if($lang != null){
            $query->selectRaw('
                assets_dep_calc_d.dep_calc_d_id as id,
                assets_dep_calc_d.dep_calc_m_id ,
                assets_dep_calc_d.asset_m_id ,
                assets_m.name_'.$lang.' as asset_name,
                assets_dep_calc_d.value,
                assets_dep_calc_d.daily_depreciation,
                assets_dep_calc_d.total_deprecation,
                assets_dep_calc_d.remaining_value
                ');
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('asset_name' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }


    public static function add_depr_calculations_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_depr_calculations_d($seed)
    {
        return DB::table('assets_dep_calc_d')->insertGetId($seed);
    }

    public static function update_assets_selling($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('dep_calc_m_id' , $id )->update($seed);
    }

}
