<?php

namespace App\Models\Barbers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BarberBooking extends Model
{
    protected $primaryKey     = 'barber_booking_id';
    public static $main_table = 'barber_bookings';
    public $table             = 'barber_bookings';

    public static $rules  = array(
        'branch_id'           => 'required|numeric',
        'barber_id'           => 'required|numeric',
        'barber_booking_date' => 'required|date',
        'start_time'          => 'required|numeric',
    );

    public static function all_barber_bookings($params = null)
    {
        $query = DB::table(self::$main_table)
//            ->select(DB::raw("GROUP_CONCAT(distinct b_services.name_ar) as services_names"))
            ->select(DB::raw("GROUP_CONCAT(distinct items.name_ar) as services_names"))
//            ->leftjoin("b_services",\DB::raw("FIND_IN_SET(b_services.service_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin("items",\DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
//            ->leftjoin('barber_customers', self::$main_table.'.barber_customer_id', '=', 'barber_customers.barber_customer_id')
            ->leftjoin('customers', self::$main_table.'.barber_customer_id', '=', 'customers.customer_id')

            ->leftjoin('b_times as from_time', self::$main_table.'.start_time', '=', 'from_time.time_id')
            ->leftjoin('b_times as to_time', self::$main_table.'.end_time', '=', 'to_time.time_id')
            ->orderBy(self::$main_table.'.barber_booking_id', 'desc')
            ->groupBy(self::$main_table.'.barber_booking_id');

        if($params['lang'] != null){
            $query->selectRaw('
                barber_booking_id as id ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$params['lang'].' as barber_name ,
                customers.name_'.$params['lang'].' as barber_customer_name ,
                customers.phone as barber_customer_mobile ,
                customers.notes as barber_customer_notes ,
                from_time.time_title as from_time_title ,
                to_time.time_title as to_time_title , '.
                self::$main_table.'.start_time as booking_start_time ,'.
                self::$main_table.'.barber_booking_date ,'.
                self::$main_table.'.end_time as booking_end_time ,'.
                self::$main_table.'.has_invoice ,'.
                self::$main_table.'.barber_booking_status ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }


        if(isset($params['has_invoice'])){
            $query->where(self::$main_table.'.has_invoice', $params['has_invoice']);
        }

        
        if(isset($params['active_date']))
            $query->where(self::$main_table.'.barber_booking_date', $params['active_date']);

//        if(isset($params['status']))
//            $query->where(self::$main_table.'.barber_booking_status', $params['status']);
        if(isset($params['barber']))
            $query->where(self::$main_table.'.barber_id', $params['barber']);

        $data = $query->get();
        return $data;
    }

    public static function get_barber_booking($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
//            ->select(DB::raw("GROUP_CONCAT(distinct b_services.name_ar) as services_names"))
            ->select(DB::raw("GROUP_CONCAT(distinct items.name_ar) as services_names"))
//            ->leftjoin("b_services",\DB::raw("FIND_IN_SET(b_services.service_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin("items",\DB::raw("FIND_IN_SET(items.item_id,barber_bookings.services)"),">",\DB::raw("'0'"))
            ->leftjoin('barber_m', self::$main_table.'.barber_id', '=', 'barber_m.barber_m_id')
//            ->leftjoin('barber_customers', self::$main_table.'.barber_customer_id', '=', 'barber_customers.barber_customer_id')
            ->leftjoin('customers', self::$main_table.'.barber_customer_id', '=', 'customers.customer_id')
            ->where('barber_booking_id', $id);

        if($lang != null){
            $query->selectRaw('
                barber_booking_id as id ,'.
                self::$main_table.'.services ,'.
                self::$main_table.'.barber_id ,
                barber_m.name_'.$lang.' as barber_name ,
                barber_m.image as barber_image ,
                customers.name_'.$lang.' as barber_customer_name ,
                customers.phone as barber_customer_mobile ,
                customers.notes as barber_customer_notes ,'.
                self::$main_table.'.start_time as booking_start_time ,'.
                self::$main_table.'.end_time as booking_end_time ,'.
                self::$main_table.'.has_invoice ,'.
                self::$main_table.'.total_vat ,'.
                self::$main_table.'.total_without_vat ,'.
                self::$main_table.'.total_with_vat ,'.
                self::$main_table.'.total_price ,'.
                self::$main_table.'.coupon_discount ,'.
                self::$main_table.'.points_discount ,'.
                self::$main_table.'.barber_booking_status
            ');
        }

        $data = $query->first();
        return $data;
    }
}
