<?php

namespace App\Models\Barbers;

use Illuminate\Database\Eloquent\Model;
use DB;

class BarberShopTime extends Model
{
    protected $primaryKey     = 'barber_shop_time_id';
    public static $main_table = 'barber_shop_times';
    public $table             = 'barber_shop_times';

    public static $rules = array(
        'beginning_work' => 'required',
        'end_work'       => 'required',
    );

    public static function all_barber_shop_times($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.barber_shop_time_id', 'asc');

        if(isset($params['lang']))
            $query->selectRaw('
                barber_shop_time_id as id ,'.
                self::$main_table.'.day_name_'.$params['lang'].' as day_name ,'.
                self::$main_table.'.day_name_ar ,'.
                self::$main_table.'.day_name_en ,'.
                self::$main_table.'.beginning_work ,'.
                self::$main_table.'.end_work ,'.
                self::$main_table.'.is_day_off ,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.day_name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.day_name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function update_barber_shop_time($seed, $id)
    {
        return DB::table(self::$main_table)->where('barber_shop_time_id', $id)->update($seed);
    }
}
