<?php

namespace App\Models\Elevators;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ElevatorsQuotation extends Model
{
    protected $primaryKey     = 'quotation_id';
    public static $main_table = 'elevators_quotations';
    public $table             = 'elevators_quotations';

    public static $master_rules = array(

    );

    public static $details_rules = array(

    );

    public static function all_quotations($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftjoin('elevators_r_models_m', function ($join) {
                $join->on(DB::raw('FIND_IN_SET(elevators_r_models_m.model_m_id,elevators_quotations.models_id)'),'>', DB::raw("'0'"));
            })
            ->leftJoin('taxes', 'elevators_quotations.tax_id','taxes.tax_id')
            ->leftJoin('quotations_payments', 'elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->leftJoin('quotations_payments_installments', 'quotations_payments_installments.payment_id','quotations_payments.payment_id')
            ->leftJoin('citys', 'elevators_quotations.city_id','citys.city_id')
            ->leftJoin('elevators_types', 'elevators_quotations.type_id','elevators_types.type_id')
            ->leftJoin('sales_agents', 'elevators_quotations.sales_agent_id','sales_agents.sales_agent_id')
            ->leftJoin('delegates', 'elevators_quotations.delegate_id','delegates.delegate_id')
            ->orderBy(self::$main_table.'.quotation_id', 'desc')
            ->groupBy('elevators_quotations.quotation_id');

        if($params['lang'] != null){
            $query->selectRaw('
                elevators_quotations.quotation_id as id ,
                elevators_quotations.date,
                elevators_quotations.description,
                elevators_quotations.tax_id,
                taxes.name_'.$params['lang'].' as tax_name,
                elevators_quotations.tax_percentage,
                elevators_quotations.price_with_vat,
                elevators_quotations.price_without_vat,
                elevators_quotations.warranty,
                elevators_quotations.sales_agent_id,
                sales_agents.name_'.$params['lang'].' as sales_agent_name,
                elevators_quotations.customer_id,
                elevators_quotations.book_contract_number,
                customers.name_'.$params['lang'].' as customer_name,
                customers.commercial_registeration_no ,
                customers.vat_register_number ,
                customers.phone ,
                elevators_quotations.invoice_code ,

                elevators_quotations.delegate_id,
                delegates.name_'.$params['lang'].' as delegate_name,
                elevators_quotations.client_response,
                elevators_quotations.admin_response,
                elevators_quotations.is_contract ,
                elevators_quotations.contract_status ,
                elevators_quotations.models_id,
                GROUP_CONCAT(distinct elevators_r_models_m.name_'.$params['lang'].') as models_name ,
                elevators_r_models_m.name_'.$params['lang'].' as model_name,
                elevators_quotations.type_id,
                elevators_types.name_'.$params['lang'].' as type_name,
                COUNT(distinct(quotations_payments.payment_id)) as payments_count,
                COUNT(DISTINCT CASE WHEN quotations_payments.voucher_id > 0 THEN quotations_payments.payment_id ELSE NULL END) as paid_count,
                elevators_quotations.city_id,
                citys.name_'.$params['lang'].' as city_name,
                elevators_quotations.floors_count,
                elevators_quotations.elevators_count,
                elevators_quotations.active,
                elevators_quotations.add_user,
                elevators_quotations.add_date
            ');
        }

        if(isset($params['active']))
            $query->where('elevators_quotations.active', $params['active']);

        if(isset($params['is_contract']))
            $query->where('elevators_quotations.is_contract', $params['is_contract']);

        if(isset($params['contract_status']))
            $query->where('elevators_quotations.contract_status', $params['contract_status']);

        if(isset($params['customer_id']))
            $query->where('elevators_quotations.customer_id', $params['customer_id']);

        if(isset($params['type_id']))
            $query->where('elevators_quotations.type_id', $params['type_id']);

        if(isset($params['delegate_id']))
            $query->where('elevators_quotations.delegate_id', $params['delegate_id']);

        if(isset($params['add_user']))
            $query->where('elevators_quotations.add_user', $params['add_user']);

        if(isset($params['client_response']))
            $query->whereIn('elevators_quotations.client_response', $params['client_response']);

        if(isset($params['admin_response']))
            $query->whereIn('elevators_quotations.admin_response', $params['admin_response']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_'.$params['lang'], 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_quotation($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('citys', 'elevators_quotations.city_id','citys.city_id')
            ->leftJoin('taxes', 'elevators_quotations.tax_id','taxes.tax_id')
            ->leftJoin('quotations_payments', 'elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->leftJoin('elevators_types', 'elevators_quotations.type_id','elevators_types.type_id')
            ->leftJoin('sales_agents', 'elevators_quotations.sales_agent_id','sales_agents.sales_agent_id')
            ->leftJoin('delegates', 'elevators_quotations.delegate_id','delegates.delegate_id')
            ->leftjoin('elevators_r_models_m', function ($join) {
                $join->on(DB::raw('FIND_IN_SET(elevators_r_models_m.model_m_id,elevators_quotations.models_id)'),'>', DB::raw("'0'"));
            })
            ->where('elevators_quotations.quotation_id', $id);

        if($lang != null){
            $query->selectRaw('
                elevators_quotations.quotation_id as id ,
                elevators_quotations.date,
                elevators_quotations.description,
                elevators_quotations.tax_id,
                taxes.name_'.$lang.' as tax_name,
                elevators_quotations.tax_percentage,
                elevators_quotations.price_with_vat,
                elevators_quotations.price_without_vat,
                elevators_quotations.warranty,
                elevators_quotations.sales_agent_id,
                sales_agents.name_'.$lang.' as sales_agent_name,
                sales_agents.phone as sales_agent_mobile,
                elevators_quotations.customer_id,
                elevators_quotations.book_contract_number,

                customers.name_'.$lang.' as customer_name,
                customers.phone ,
                customers.address as customer_address,
                customers.commercial_registeration_no ,
                customers.vat_register_number ,
                elevators_quotations.invoice_code ,

                elevators_quotations.delegate_id,
                delegates.name_'.$lang.' as delegate_name,
                elevators_quotations.client_response,
                elevators_quotations.admin_response,
                elevators_quotations.is_contract,
                elevators_quotations.contract_status,
                elevators_quotations.models_id,
                GROUP_CONCAT(distinct elevators_r_models_m.name_'.$lang.') as models_name ,
                COUNT(distinct(quotations_payments.payment_id)) as payments_count,
                COUNT(DISTINCT CASE WHEN quotations_payments.voucher_id > 0 THEN quotations_payments.payment_id ELSE NULL END) as paid_count,

                elevators_quotations.type_id,
                elevators_types.name_'.$lang.' as type_name,

                elevators_quotations.city_id,
                citys.name_'.$lang.' as city_name,
                elevators_quotations.floors_count,
                elevators_quotations.elevators_count,
                elevators_quotations.active,
                elevators_quotations.add_user,
                elevators_quotations.add_date
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_quotation_payments($params = null)
    {
        $query = DB::table('quotations_payments')
            ->leftJoin('elevators_quotations', 'elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->orderBy('quotations_payments.payment_id','asc')
            ->groupBy('quotations_payments.payment_id');

        if($params['lang'] != null){
            $query->selectRaw('
                quotations_payments.quotation_id ,
                quotations_payments.payment_id ,
                quotations_payments.payment_name ,
                quotations_payments.percentage ,
                quotations_payments.details ,
                quotations_payments.start_date ,
                quotations_payments.end_date ,
                quotations_payments.amount ,
                elevators_quotations.invoice_code ,
                quotations_payments.remaining as remaining,
                quotations_payments.paid as paid,
                quotations_payments.status ,
                if(quotations_payments.remaining > 0 , 0 ,1 ) as payment_status,
                elevators_quotations.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,
                customers.phone

            ');
        }

        if(isset($params['customer_id']))
            $query->where('elevators_quotations.customer_id', $params['customer_id']);

        if(isset($params['customer_phone']))
            $query->where('customers.phone', $params['customer_phone']);

        if(isset($params['quotation_id']))
            $query->where('elevators_quotations.quotation_id', $params['quotation_id']);

        if(isset($params['invoice_code']))
            $query->where('elevators_quotations.invoice_code', $params['invoice_code']);

        if(isset($params['status']))
            $query->where('quotations_payments.status', $params['status']);

        if(isset($params['from_date']) && isset($params['to_date']))
            $query->whereBetween('elevators_quotations.date',[$params['from_date'],$params['to_date']]);

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();

        }
        foreach($data as $item){
            $item->installments = DB::table('quotations_payments_installments')
                ->Join('receipt_vouchers', 'receipt_vouchers.receipt_voucher_id','quotations_payments_installments.voucher_id')
                ->where('quotations_payments_installments.payment_id',$item->payment_id)
                ->where('receipt_vouchers.receipt_voucher_active', '=' , 1 )
                ->selectRaw('
                    quotations_payments_installments.id ,
                    quotations_payments_installments.payment_id ,
                    quotations_payments_installments.voucher_id ,
                    receipt_vouchers.amount
                    ')
                ->get()->toArray();
        }
        if(isset($params['payment_id'])){
            $data = $query->where('quotations_payments.payment_id', $params['payment_id'])->first();
        }
        return $data;
    }
    public static function get_payments_installments($lang = null, $id)
    {
        $query = DB::table('quotations_payments_installments')
            ->leftJoin('quotations_payments', 'quotations_payments_installments.payment_id','quotations_payments.payment_id')
            ->Join('receipt_vouchers', 'receipt_vouchers.receipt_voucher_id','quotations_payments_installments.voucher_id')
            ->where('quotations_payments_installments.payment_id',$id)
            ->where('receipt_vouchers.receipt_voucher_active', '=' , 1 )
            ->groupBy('quotations_payments.payment_id');


        if($lang != null){
            $query->selectRaw('
                quotations_payments.id ,
                quotations_payments.payment_id ,
                quotations_payments.voucher_id ,
                receipt_vouchers.amount
            ');
        }

            $data = $query->get();

        return $data;
    }
    public static function quotations_lookups($lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->orderBy(self::$main_table.'.quotation_id', 'desc')
            ->where('is_contract', 1)
            ->where('contract_status', 1)
            ->where('active', 1)
            ->groupBy('elevators_quotations.quotation_id');

        if($lang != null){
            $query->selectRaw('
                elevators_quotations.quotation_id as id ,
                customers.name_'.$lang.' as customer_name,
                elevators_quotations.invoice_code as contract_number
            ');
        }

            $data = $query->get();

        return $data;
    }

    public static function add_quotation($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_payment($seed)
    {
        return DB::table('quotations_payments')->insertGetId($seed);
    }
    public static function update_payment($id , $seed)
    {
        return DB::table('quotations_payments')->where('payment_id', $id)->update($seed);
    }

    public static function update_quotation($seed, $id)
    {
        return DB::table(self::$main_table)->where('quotation_id', $id)->update($seed);
    }
    public static function delete_attachments($id)
    {
        return DB::table('quotations_attachments')->where('attachment_id',$id)->delete();

    }
    public static function delete_quotation($id)
    {
        return DB::table(self::$main_table)->where('quotation_id', $id)->update(array('active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

}
