<?php

namespace App\Models\Finance;
use Illuminate\Database\Eloquent\Model;
use DB;

class AccountTree extends Model
{
    protected $primaryKey = 'account_tree_id';

    public static $main_table = 'account_tree';
    public $table = 'account_tree';

    public static $rules = array(
        'name_en'       => 'required|string|min:3|unique:account_tree',
        'name_ar'       => 'required|string|min:3|unique:account_tree',
        'account_code'  => 'required|string|unique:account_tree',
    );

    public static function active_account_trees($lang = null, $params = null)
    {
        $query =  DB::table(self::$main_table);

        if($lang != null){
            $query->selectRaw('
            account_tree_id as id  ,
            parent_id ,
            account_code ,
            name_'.$lang.' as name ,
            name_ar ,
            name_en ,
            account_type ,
            if(account_type = "1" , "folder" , "item") as type ,
            if(account_type = "1" , true , false ) as hasChild ,
            account_nature  ,
            protection ,
            active ,
            cost_center ,
            cost_center_id,
            main_account ,
            level_chars
            ');
        }

        if(isset($params['account_type']))
             $query->where('account_type' , $params['account_type']);

        if(isset($params['active']))
            $query->where('active' , $params['active']);

        if(isset($params['parent']))
            $query->where('parent_id' , $params['parent']);

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('account_code' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_en' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['start_with']))
            $query->where('account_code' , 'like' , $params['start_with']."%");

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_account_tree($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('account_tree_id' , $id);

        if($lang != null){
            $query->selectRaw('
            account_tree_id as id  ,
            parent_id ,
            account_code ,
            name_'.$lang.' as name ,
            name_ar ,
            name_en ,
            account_type ,
            if(account_type = "1" , "folder" , "item") as type ,
            if(account_type = "1" , true , false ) as hasChild ,
            account_nature ,
            account_level ,
            protection ,
            active ,
            cost_center ,
            cost_center_id,
            main_account ,
            level_chars
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_account_tree($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_account_tree($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('account_tree_id' , $id )->update($seed);
    }

    public static function delete_account_tree($id)
    {
        return DB::table(self::$main_table)->where('account_tree_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }


}
