<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class Currency extends Model
{

    protected $primaryKey = 'currency_id';

    public static $main_table = 'currencys';
    public  $table = 'currencys';


    public static $rules = array(
        'name_ar'  => 'required|unique:currencys',
        'name_en'  => 'required|unique:currencys',
    );

    public static function all_currency($params = null)
    {
        $query =  DB::table(self::$main_table);

        if(isset($params['lang'])){
            $query->selectRaw('
                currency_id as id  ,
                name_ar ,
                name_en ,
                name_'.$params['lang'].' as name ,
                big_sign_'.$params['lang'].' as big_sign ,
                small_sign_'.$params['lang'].' as small_sign ,
                currency_code ,
                add_date ,
                equivalent_value
            ');
        }

        if(isset($params['active']))
            $query->where('currency_active' , $params['active'] );


        if(isset($params['word']) && strlen($params['word']) >  0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_ar' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere(self::$main_table . '.currency_id', $params['word']);
            });
        }

        if(isset($params['id']) && $params['id'] != null){
            $query->where('currency_id' , $params['id']);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_currency($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('currency_id' , $id);

        if($lang != null){
            $query->selectRaw('
                currency_id as id  ,
                name_ar ,
                name_en ,
                name_'.$lang.' as name ,
                big_sign_'.$lang.' as big_sign ,
                small_sign_'.$lang.' as small_sign ,
                currency_code ,
                add_date ,
                equivalent_value
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_currency($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_currency($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('currency_id' , $id )->update($seed);
    }

    public static function delete_currency($id)
    {
        return DB::table(self::$main_table)->where('currency_id' , $id )->update( array('currency_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

}