<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class DailyJournal extends Model
{

    protected $primaryKey           = 'daily_journal_m_id';
    public static $master_table     = 'daily_journal_m';
    public $table     = 'daily_journal_m';

    public static $master_rules = array(
        'description'       => 'string|nullable',
        'year_ser'          => 'required|numeric',
        'month_ser'         => 'required|numeric',
        'branch_ser'        => 'required|numeric',
        'journal_date'      => 'required|date'
    );

    public static $detaile_rules = array(
        'description'           => 'string|nullable',
        'account_tree_id'       => 'required|numeric|min:1' ,
        'daily_journal_m_id'    => 'required|numeric',
        'debit'                 => 'required|numeric|min:0',
        'credit'                => 'required|numeric|min:0'
    );

    public static function all_daily_journals($params = null)
    {
        $query =  DB::table(self::$master_table)
            ->leftjoin('daily_types' , self::$master_table.'.daily_type_id' , '=' , 'daily_types.daily_type_id')
            ->leftjoin('branchs' , self::$master_table.'.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('finance_years' , self::$master_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->orderBy(self::$master_table.'.daily_journal_m_id' , 'desc');

        if(isset($params['lang'])){
            $query->selectRaw('
                daily_journal_m_id as m_id  ,
                year_ser as journal_code ,
                description ,
                branchs.branch_id  ,
                branchs.name_'.$params['lang'].' as branch_name ,
                finance_years.finance_year_id ,
                finance_years.name as finance_year_name ,
                journal_date ,
                year_ser ,
                month_ser ,
                branch_ser ,
                daily_types.daily_type_id ,
                daily_types.name_'.$params['lang'].' as daily_type ,
                document_id ,
                auto_generated ,
                journal_active ,'.
                self::$master_table.'.add_date
            ');
        }

        if(isset($params['active'])){
            $query->where('journal_active' , $params['active']);
        }

        if(isset($params['branch'])){
            $query->where(self::$master_table.'.branch_id' , $params['branch']);
        }

        if(isset($params['finance_year'])){
            $query->where(self::$master_table.'.finance_year_id' , $params['finance_year']);
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

    return $data;
    }

    public static function get_daily_journal_m($id , $lang = null)
    {
        $query =  DB::table(self::$master_table)
            ->leftjoin('daily_types' , self::$master_table.'.daily_type_id' , '=' , 'daily_types.daily_type_id')
            ->leftjoin('branchs' , self::$master_table.'.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('finance_years' , self::$master_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->where('daily_journal_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
            daily_journal_m_id as m_id ,
            year_ser as journal_code ,
            description ,
            finance_years.finance_year_id ,
            finance_years.name as finance_year_name ,
            branchs.branch_id  ,
            branchs.name_'.$lang.' as branch_name ,
            journal_date ,
            year_ser ,
            month_ser ,
            branch_ser ,
            daily_types.daily_type_id ,
            daily_types.name_'.$lang.' as daily_type ,
            document_id ,
            auto_generated ,
            journal_active ,'.
            self::$master_table.'.add_date
            ');
        }

        $data = $query->first();
        return $data;

    }


    public static function get_daily_journal_d($id , $lang = null)
    {
        $query =  DB::table('daily_journal_d')
            ->leftjoin('account_tree' , 'daily_journal_d.account_tree_id' , '=' , 'account_tree.account_tree_id')
            ->where('daily_journal_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
            daily_journal_m_id as m_id  ,
            daily_journal_d_id as d_id ,
            description ,
            if( debit > 0 , 2 , 1) as d_type ,
            debit ,
            credit ,
            account_tree.account_tree_id ,
            account_code ,
            account_tree.name_'.$lang.' as account_tree ,
            cost_centers  ,
            attach_ext
            ');
        }

        $data = $query->get();
        return $data;

    }

    public static function get_next($id , $branch){
        return DB::table(self::$master_table)
            ->where('daily_journal_m_id' , '>' , $id)
            ->where('journal_active' , 1)
            ->where('confirmed' , 1)
            ->where('branch_id' , $branch)
            ->selectRaw('daily_journal_m_id as m_id')
            ->first();
    }

    public static function get_previous($id, $branch){
        return DB::table(self::$master_table)
            ->where('daily_journal_m_id' , '<' , $id)
            ->where('journal_active' , 1)
            ->where('confirmed' , 1)
            ->where('branch_id' , $branch)
            ->selectRaw('daily_journal_m_id as m_id')
            ->orderBy('daily_journal_m_id' , 'desc')
            ->first();
    }

    public static function get_last($branch){
        return DB::table(self::$master_table)
            ->where('journal_active' , 1)
            ->where('confirmed' , 1)
            ->where('branch_id' , $branch)
            ->selectRaw('daily_journal_m_id as m_id')
            ->orderBy('daily_journal_m_id' , 'desc')
            ->first();
    }

    public static function get_files($id){
        return DB::table('daily_journal_files')
            ->where('daily_journal_id' , $id)
            ->get();
    }

    public static function get_account_balance($id , $lang , $params = null)
    {
        $query = DB::table('daily_journal_d')
            ->leftjoin('account_tree' , 'daily_journal_d.account_tree_id' , '=' , 'account_tree.account_tree_id')
            ->leftjoin('daily_journal_m' , 'daily_journal_d.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->leftjoin('branchs' , 'daily_journal_m.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('finance_years' , 'daily_journal_m.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->leftjoin('daily_types' , 'daily_journal_m.daily_type_id' , '=' , 'daily_types.daily_type_id')
            ->orderBy('journal_date' )
            ->where('journal_active' , 1)
            ->where('confirmed' , 1)
            ->where('daily_journal_d.account_tree_id' , $id);

        if(isset($params['before'])){
            $query->where('journal_date' , '<' , $params['before'] );
        }elseif(isset($params['from']) && isset($params['to']) ){
            $query->where('journal_date' , '>=' , $params['from'] )
                  ->where('journal_date' , '<=' , $params['to'] );
        }
        if(isset($params['branch_id'])){
            $query->where('daily_journal_m.branch_id' , $params['branch_id'] );
        }

        if(isset($params['total'])){

            $data = $query->selectRaw('sum(debit) as debit , sum(credit) as credit , (sum(debit) - sum(credit)) as total')
                ->first();

        }else{

            $data = $query->selectRaw('daily_journal_d.daily_journal_m_id as m_id , daily_journal_m.branch_id,  year_ser as journal_code , branch_ser , month_ser  , journal_date , debit , credit , daily_types.name_'.$lang.' as daily_type ,daily_types.daily_type_id, daily_journal_d.description as description , document_id  ')
                ->get();

        }

        return $data;

    }

    public static function add_daily_journal_m($seed)
    {
        return DB::table(self::$master_table)->insertGetId($seed);
    }

    public static function add_daily_journal_d($seed)
    {
        return DB::table('daily_journal_d')->insertGetId($seed);
    }

    public static function update_daily_journal_m($seed ,  $id)
    {
        return DB::table(self::$master_table)->where('daily_journal_m_id' , $id )->update($seed);
    }

    public static function delete_daily_journal_m($id)
    {
        return DB::table(self::$master_table)->where('daily_journal_m_id' , $id )->update( array('journal_active' => 0 , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )  );
    }

    public static function delete_daily_journal_d($id)
    {
        return DB::table('daily_journal_d')->where('daily_journal_m_id' , $id)->delete();
    }

    public static function delete_daily_journal_files($id)
    {
        return DB::table('daily_journal_files')->where('daily_journal_id' , $id)->delete();
    }




}
