<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class MultiVoucher extends Model
{
        protected $primaryKey     = 'multi_voucher_m_id';
        public static $main_table = 'multi_voucher_m';
        public $table             = 'multi_voucher_m';

        public static $master_rules = array(
            'branch_id'       => 'required|numeric' ,
            'finance_year_id' => 'required|numeric' ,
            'action_date'     => 'required|date',
            'description'     => 'required|string|min:3',
            'currency_id'     =>'required|Integer',
        );

        public static $details_rules = array(
            'voucher_type'=>'required|Integer',
            'amount'=>'required',
            'dis_type'=>'required|Integer'
        );


    public static function all_multi_vouchers($params = null)
    {

        $query = DB::table(self::$main_table)
                ->leftJoin('currencys',self::$main_table.'.currency_id','currencys.currency_id')
                ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
                ->leftjoin('multi_voucher_d' , self::$main_table.'.multi_voucher_m_id' , '=' , 'multi_voucher_d.multi_voucher_m_id')
                ->groupBy(self::$main_table.'.multi_voucher_m_id')
                ->orderBy(self::$main_table.'.multi_voucher_m_id', 'desc');

                if($params['lang'] != null){
                    $query->selectRaw(
                        self::$main_table.'.multi_voucher_m_id as id ,
                        conversion_type_id,
                        currencys.name_'.$params['lang'].' as currency_name ,
                        sum( case when voucher_type = 1 AND multi_voucher_d_active = 1 then amount end ) as total_depit ,
                        sum( case when voucher_type = 2 AND multi_voucher_d_active = 1 then amount end ) as total_credit ,
                        sum( case when voucher_type = 1 AND multi_voucher_d_active = 1 then total_vat end ) as total_depit_vat ,
                        sum( case when voucher_type = 2 AND multi_voucher_d_active = 1 then total_vat end ) as total_credit_vat ,

                        multi_voucher_m.action_date ,
                        multi_voucher_m.daily_journal_m_id ,
                        daily_journal_m.year_ser as journal_code ,
                        multi_voucher_m.description ,
                        multi_voucher_active ,
                        multi_voucher_m.add_date ,
                        multi_voucher_m.add_user
                    ');
                }

        if(isset($params['active']))
            $query->where('multi_voucher_active', $params['active']);

        if(isset($params['branch'])){
            $query->where(self::$main_table.'.branch_id' , $params['branch']);
        }

        if(isset($params['finance_year'])){
            $query->where(self::$main_table.'.finance_year_id' , $params['finance_year']);
        }

        if(isset($params['word']) && strlen($params['word']) >  0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('multi_voucher_m.description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('action_date', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_multi_voucher_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('multi_voucher_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                multi_voucher_m_id as id ,
                finance_year_id ,
                branch_id,
                year_ser ,
                month_ser ,
                branch_ser ,
                action_date ,
                conversion_type_id ,
                currency_id ,
                daily_journal_m_id ,
                multi_voucher_active as active ,
                description ,
                add_date ,
                add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_multi_voucher_d($id, $lang = null)
    {
        $query = DB::table('multi_voucher_d')
            ->where('multi_voucher_m_id', $id)
            ->where('multi_voucher_d_active' , 1 );

        if($lang != null){
            $query->selectRaw('
                multi_voucher_m_id as m_id ,
                multi_voucher_d_id as d_id ,
                voucher_type ,
                cost_centers ,
                amount_without_vat ,
                total_vat ,
                amount ,
                tax_id ,
                dis_type ,
                dis_treasury_id ,
                dis_bank_id ,
                dis_customer_id ,
                dis_supplier_id ,
                dis_account_tree_id ,
                description ,
                add_date ,
                add_user
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_attachs($id)
    {
        return DB::table('multi_voucher_attachments')
            ->where('multi_voucher_id' , $id)
            ->selectRaw('
                attachment_id as id ,
                multi_voucher_id ,
                file_name ,
                file_path ,
                file_ext ,
                add_date ,
                add_user
        ')->get();
    }

    public static function add_multi_voucher_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_multi_voucher_d($seed)
    {
        return DB::table('multi_voucher_d')->insertGetId($seed);
    }

    public static function update_multi_voucher_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('multi_voucher_m_id', $id)->update($seed);
    }

    public static function update_multi_voucher_d($seed, $id)
    {
        return DB::table('multi_voucher_d')->where('multi_voucher_d_id', $id)->update($seed);
    }

    public static function delete_multi_voucher_m($id)
    {
        return DB::table(self::$main_table)->where('multi_voucher_m_id', $id)->update(array('multi_voucher_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_multi_voucher_d($id)
    {
        return DB::table('multi_voucher_d')->where('multi_voucher_m_id', $id)->delete();
    }
}
