<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class ReceiptVoucher extends Model
{

    protected $primaryKey       = 'receipt_voucher_id';
    public static $main_table   = 'receipt_vouchers';
    public $table               = 'receipt_vouchers';


    public static $rules = array(
        'branch_id'         => 'required|numeric' ,
        'finance_year_id'   => 'required|numeric' ,
        'from_type'         => 'required|numeric' ,
        'to_type'           => 'required|numeric' ,
        'amount'            => 'required|numeric',
        'description'       => 'required|string',
        'action_date'       => 'required|date',
        'document_number'   => 'unique:receipt_vouchers',
    );

    public static function all_receipt_voucher( $params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftjoin('daily_journal_m' , self::$main_table.'.daily_journal_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->orderBy('receipt_voucher_id' , 'desc');


        if($params['lang'] != null){
            $query
                ->leftjoin('account_tree as account_tree_to' ,  'receipt_vouchers.to_account_tree_id' , '=' , 'account_tree_to.account_tree_id')
                ->leftjoin('treasurys' ,  'receipt_vouchers.to_treasury_id' , '=' , 'treasurys.treasury_id')
                ->leftjoin('banks' ,  'receipt_vouchers.to_bank_id' , '=' , 'banks.bank_id')
                ->leftjoin('account_tree as account_tree_from' ,  'receipt_vouchers.from_account_tree_id' , '=' , 'account_tree_from.account_tree_id')
                ->leftjoin('purchases_vendors' ,  'receipt_vouchers.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
                ->leftjoin('customers' ,  'receipt_vouchers.from_customer_id' , '=' , 'customers.customer_id')
                ->selectRaw('
                    receipt_voucher_id as id  ,
                    receipt_vouchers.year_ser ,
                    receipt_vouchers.month_ser ,
                    receipt_vouchers.branch_ser ,
                    receipt_vouchers.action_date ,
                    receipt_vouchers.daily_journal_id ,
                    daily_journal_m.year_ser as journal_code ,
                    receipt_vouchers.cost_center_id ,
                    receipt_vouchers.delegate_id ,
                    receipt_vouchers.amount ,
                    receipt_vouchers.invoice_type ,
                    receipt_vouchers.description ,

                    from_type ,
                    from_account_tree_id ,
                    from_supplier_id ,
                    from_customer_id ,

                    CASE
                        WHEN from_type = 1 THEN account_tree_from.name_'.$params['lang'].'
                        WHEN from_type = 2 THEN purchases_vendors.name_'.$params['lang'].'
                        WHEN from_type = 3 THEN customers.name_'.$params['lang'].'
                        ELSE ""
                    END as from_type_name ,

                    to_type ,
                    to_account_tree_id ,
                    to_treasury_id ,
                    to_bank_id ,

                    CASE
                        WHEN to_type = 1 THEN account_tree_to.name_'.$params['lang'].'
                        WHEN to_type = 2 THEN treasurys.treasury_name_'.$params['lang'].'
                        WHEN to_type = 3 THEN banks.name_'.$params['lang'].'
                        WHEN to_type = 4 THEN cheque_number
                        ELSE ""
                    END as receipt_type ,

                    due_date ,
                    cheque_number ,

                    purchases_agent_id ,
                    receipt_vouchers.auto_generated ,
                    receipt_vouchers.sales_agent_id

                ');
        }


        if(isset($params['active']))
            $query->where('receipt_voucher_active' , $params['active'] );

        if(isset($params['branch'])){
            $query->where(self::$main_table.'.branch_id' , $params['branch']);
        }

        if(isset($params['finance_year'])){
            $query->where(self::$main_table.'.finance_year_id' , $params['finance_year']);
        }

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('receipt_vouchers.description' , 'LIKE' , "%".$params['word']."%")
                ->orWhere('receipt_vouchers.action_date' , 'LIKE' , "%".$params['word']."%")


                ->orWhere('account_tree_from.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('treasurys.treasury_name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('banks.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('account_tree_to.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('purchases_vendors.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%")
                ->orWhere('customers.name_'.$params['lang'] , 'LIKE' , "%".$params['word']."%");


            });

        }


        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }


    return $data;
    }

    public static function get_receipt_voucher($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('receipt_voucher_id' , $id);

        if($lang != null){
            $query
                ->leftjoin('account_tree as account_tree_to' ,  'receipt_vouchers.to_account_tree_id' , '=' , 'account_tree_to.account_tree_id')
                ->leftjoin('treasurys' ,  'receipt_vouchers.to_treasury_id' , '=' , 'treasurys.treasury_id')
                ->leftjoin('banks' ,  'receipt_vouchers.to_bank_id' , '=' , 'banks.bank_id')

                ->leftjoin('account_tree as account_tree_from' ,  'receipt_vouchers.from_account_tree_id' , '=' , 'account_tree_from.account_tree_id')
                ->leftjoin('purchases_vendors' ,  'receipt_vouchers.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
                ->leftjoin('customers' ,  'receipt_vouchers.from_customer_id' , '=' , 'customers.customer_id')
                ->selectRaw('
                    receipt_voucher_id as id  ,
                    finance_year_id ,
                    branch_id ,
                    year_ser ,
                    month_ser ,
                    branch_ser ,
                    action_date ,
                    daily_journal_id ,
                    receipt_vouchers.cost_center_id ,
                    voucher_type_id ,
                    delegate_id ,
                    amount ,
                    invoice_type ,
                    description ,
                    document_number ,
                    receipt_voucher_active as active ,
                    from_type ,
                    from_account_tree_id ,
                    account_tree_from.name_'.$lang.' as account_tree_from_name ,
                    from_supplier_id ,
                    receipt_vouchers.purchases_vendor_id ,
                    purchases_vendors.name_'.$lang.' as purchases_vendors_name ,
                    from_customer_id ,
                    customers.name_'.$lang.' as customer_name ,

                    to_type ,
                    to_account_tree_id ,
                    account_tree_to.name_'.$lang.' as account_tree_to_name ,
                    to_treasury_id ,
                    treasurys.treasury_name_'.$lang.' as treasury_name ,
                    to_bank_id ,
                    banks.name_'.$lang.' as bank_name ,

                    due_date ,
                    cheque_number ,
                    receipt_vouchers.auto_generated ,
                    purchases_agent_id ,
                    receipt_vouchers.sales_agent_id
                ');
        }

        $data = $query->first();
        return $data;

    }
    public static function get_receipt_voucher_d($id , $lang = null)
    {
        $query =  DB::table('receipt_vouchers_d')
            ->leftjoin('quotations_payments','quotations_payments.payment_id' , 'receipt_vouchers_d.document_id')
            // ->where('remaining','>',0)
            ->where('receipt_voucher_m_id' , $id)
            ->selectRaw('
                receipt_vouchers_d.receipt_voucher_d_id as d_id ,
                receipt_vouchers_d.receipt_voucher_m_id as m_id,
                quotations_payments.payment_id ,
                quotations_payments.payment_name ,
                quotations_payments.percentage ,
                quotations_payments.details ,
                quotations_payments.amount as payment_amount ,
                quotations_payments.paid ,
                quotations_payments.remaining ,
                receipt_vouchers_d.document_id,
                receipt_vouchers_d.amount
            ');
            $data = $query->get();

        return $data;

    }
    public static function get_attachs($id)
    {
        return DB::table('receipt_voucher_attachments')
            ->where('receipt_voucher_id' , $id)
            ->selectRaw('
                attachment_id as id ,
                receipt_voucher_id ,
                file_name ,
                file_path ,
                file_ext ,
                add_date ,
                add_user
            ')->get();
    }

    public static function add_receipt_voucher($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }
    public static function add_receipt_voucher_d($seed)
    {
        return DB::table('receipt_vouchers_d')->insertGetId($seed);
    }
    public static function update_receipt_voucher($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('receipt_voucher_id' , $id )->update($seed);
    }

    public static function delete_receipt_voucher($id)
    {
        return DB::table(self::$main_table)->where('receipt_voucher_id' , $id )->update( array('receipt_voucher_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

    public static function count_annual($id)
    {
    }
}
