<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class Treasury extends Model
{

    protected $primaryKey = 'treasury_id';

    public static $main_table = 'treasurys';
    public  $table = 'treasurys';


    public static $rules = array(
        'treasury_name_ar'  => 'required',
        'treasury_name_en'  => 'required',
        'first_balance'     => 'required|numeric',
        'first_balance_date'=> 'required|date',
    );

    public static function all_treasury($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('treasury_order');

        if(isset($params['lang'])){
            $query->selectRaw('
            treasury_id as id  , 
            treasury_name_'.$params['lang'].' as name ,
            users,
            first_balance,
            first_balance_date,
            first_balance_type,
            current_balance,
            current_balance_date,
            current_balance_type,
            add_user,
            add_date,
            treasury_active as active
            ');
        }

        if(isset($params['active']))
            $query->where('treasury_active' , $params['active'] );
        
        if(isset($params['user']) && strlen($params['user']) >  0)
            $query->whereRaw("find_in_set(".$params['user']." , users)");
        
        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('treasury_name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('treasury_name_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }

        
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_treasury($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('treasury_id' , $id);

        if($lang != null){
            $query->selectRaw('
            treasury_id as id  , 
            treasury_name_'.$lang.' as name ,
            account_tree_id ,
            users,
            first_balance,
            first_balance_date,
            first_balance_type,
            current_balance,
            current_balance_date,
            current_balance_type,
            add_user,
            add_date,
            treasury_active as active
            ');
        }

        $data = $query->first();
        return $data;

    }

    public static function add_treasury($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_treasury($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('treasury_id' , $id )->update($seed);
    }

    public static function delete_treasury($id)
    {
        return DB::table(self::$main_table)->where('treasury_id' , $id )->update( array('treasury_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

}