<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class VoucherReceipt extends Model
{

    protected $primaryKey       = 'voucher_receipt_id';
    public static $main_table   = 'voucher_receipts';
    public $table               = 'voucher_receipts';
    

    public static $rules = array(
        'branch_id'         => 'required|numeric' , 
        'finance_year_id'   => 'required|numeric' ,
        'from_type'         => 'required|numeric' ,
        'collect_type'      => 'required|numeric' ,
        'amount'            => 'required|numeric|min:1',
        'description'       => 'required|string|min:3',
        'action_date'       => 'required|date',
    );

    public static function all_voucher_receipt( $params = null)
    {
        $query =  DB::table(self::$main_table);

        if($params['lang'] != null){
            $query->selectRaw('
                voucher_receipt_id as id  , 
                year_ser ,
                month_ser , 
                branch_ser ,
                action_date ,
                daily_journal_id ,
                cost_center_id , 
                delegate_id ,
                amount , 
                invoice_type , 
                description , 

                from_type ,
                from_account_tree_id , 
                from_supplier_id , 
                from_customer_id ,

                collect_type ,
                to_account_tree_id , 
                to_treasury_id ,
                to_bank_id ,
                due_date ,
                cheq_number 

            ');
        }


        if(isset($params['active']))
            $query->where('voucher_receipt_active' , $params['active'] );
        
        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('description' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('action_date' , 'LIKE' , "%{$params['word']}%");
            });
            
        }

        
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        

    return $data;
    }

    public static function get_voucher_receipt($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('voucher_receipt_id' , $id);

        if($lang != null){
            $query->selectRaw('
                voucher_receipt_id as id  , 
                year_ser ,
                month_ser , 
                branch_ser ,
                action_date ,
                daily_journal_id ,
                cost_center_id , 
                delegate_id ,
                amount , 
                invoice_type , 
                description , 

                from_type ,
                from_account_tree_id , 
                from_supplier_id , 
                from_customer_id ,

                collect_type ,
                to_account_tree_id , 
                to_treasury_id ,
                to_bank_id ,
                due_date ,
                cheq_number 
            ');
        }
        
        $data = $query->first();
        return $data;

    }

    public static function add_voucher_receipt($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_voucher_receipt($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('voucher_receipt_id' , $id )->update($seed);
    }

    public static function delete_voucher_receipt($id)
    {
        return DB::table(self::$main_table)->where('voucher_receipt_id' , $id )->update( array('voucher_receipt_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

    public static function count_annual($id)
    {
    }
}
