<?php

namespace App\Models\FinancialStatements;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class FinancialCollections extends Model
{
    protected $primaryKey = 'collection_id';

    public static $main_table = 'financial_collections';

    public static $rules = array(
        'name_en'       => 'required|string|min:3|unique:financial_collections',
        'name_ar'       => 'required|string|min:3|unique:financial_collections',
        'statement_id'  => 'required|integer',
    );

    public static function all_financial_collections($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftJoin('financial_statements','financial_statements.statement_id','financial_collections.statement_id')
            ->orderBy('financial_collections.collection_id','desc');

        if($params['lang'] != null){
            $query->selectRaw('
                financial_collections.collection_id as id  ,
                financial_collections.name_'.$params['lang'].' as name ,
                financial_collections.name_en ,
                financial_collections.name_ar ,
                financial_collections.statement_id ,
                financial_collections.parent_id ,
                financial_collections.type ,
                financial_collections.account_id ,
                financial_collections.factor ,
                financial_collections.is_print ,
                financial_collections.balance_type ,
                financial_collections.add_user ,
                financial_collections.add_date

                ');
        }
        if(isset($params['statement_id'])){
            $query->where('financial_collections.statement_id',$params['statement_id']);
        }

        if(isset($params['word']) && strlen($params['word']) >  0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_en' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_financial_collection($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('collection_id' , $id);

        if($lang != null){
            $query->selectRaw('
                financial_collections.collection_id as id  ,
                financial_collections.name_'.$lang.' as name ,
                financial_collections.name_en ,
                financial_collections.name_ar ,
                financial_collections.statement_id ,
                financial_collections.parent_id ,
                financial_collections.type ,
                financial_collections.account_id ,
                financial_collections.factor ,
                financial_collections.is_print ,
                financial_collections.balance_type ,
                financial_collections.add_user ,
                financial_collections.add_date
            ');
        }

        $data = $query->first();
        $data->childrens = DB::table('financial_collections')->where('parent_id',$id)->get();
        return $data;

    }

    public static function add_financial_collection($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_financial_collection($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('collection_id' , $id )->update($seed);
    }

    public static function delete_financial_collection($id)
    {
        return DB::table(self::$main_table)->where('collection_id' , $id )->delete();
    }




}
