<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Category extends Model
{
    protected $primaryKey     = 'category_id';
    public static $main_table = 'categorys';
    public $table             = 'categorys';

    public static $rules = array(
        'name_en'       => 'required|string|unique:categorys' ,
        'name_ar'       => 'required|string|unique:categorys' ,
        'category_type' => 'required|numeric' ,
        // 'service_type' => 'required|numeric' ,
        'parent_id'     => 'nullable|numeric' ,
    );

    public static function all_categorys($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.category_id');

        if(isset($params['lang']))
            $query->selectRaw('
                category_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,
                parent_id ,
                category_type ,
                service_type ,
                if(category_type = "1", "folder", "item") as type ,
                if(category_type = "1", true, false ) as hasChild ,'.
                self::$main_table.'.category_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['category_type']))
            $query->where('category_type', $params['category_type']);

        if(isset($params['parent']))
            $query->where('parent_id', $params['parent']);

        if(isset($params['active']))
            $query->where('category_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_category($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('category_id', $id);

        if($lang != null)
            $query->selectRaw('
                category_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,
                parent_id ,
                category_type ,
                service_type ,
                if(category_type = "1", "folder", "item") as type ,
                if(category_type = "1", true, false ) as hasChild ,'.
                self::$main_table.'.category_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        $data = $query->first();
        return $data;
    }

    public static function get_sub_categorys($category_id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('parent_id', $category_id);

        if($lang != null)
            $query->selectRaw('
                category_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,
                parent_id ,
                category_type ,
                service_type ,
                if(category_type = "1", "folder", "item") as type ,
                if(category_type = "1", true, false ) as hasChild ,'.
                self::$main_table.'.category_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        $data = $query->get();
        return $data;
    }

    public static function add_category($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_category($seed, $id)
    {
        return DB::table(self::$main_table)->where('category_id', $id)->update($seed);
    }

    public static function delete_category($id)
    {
        return DB::table(self::$main_table)->where('category_id', $id)->update( array('category_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
