<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use DB;

class StockTransaction extends Model
{
    protected $primaryKey     = 'stock_transaction_m_id';
    public static $main_table = 'stock_transaction_m';
    public $table             = 'stock_transaction_m';

    public static $master_rules = array(
        'stock_transaction_type_id'     => 'required|numeric',
        'stock_transaction_date'        => 'required|date',
        'stock_transaction_description' => 'required',
        'warehouse_id'                  => 'required|numeric',
        'branch_id'                     => 'required|numeric',
        'finance_year_id'               => 'required|numeric',
        'year_ser'                      => 'required|numeric',
        'month_ser'                     => 'required|numeric',
        'branch_ser'                    => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'  => 'required|numeric',
        'unit_id'  => 'required|numeric',
        'quantity' => 'required|numeric',
        'price'    => 'required',
    );

    public static function all_stock_transactions($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('stock_transaction_types' , self::$main_table.'.stock_transaction_type_id' , '=' , 'stock_transaction_types.stock_transaction_type_id')
            ->leftjoin('finance_years' , self::$main_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->leftjoin('branchs' , self::$main_table.'.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->orderBy(self::$main_table.'.stock_transaction_m_id' , 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                stock_transaction_m_id as m_id ,
                stock_transaction_date ,
                stock_transaction_description ,
                warehouse_id ,'.
                self::$main_table.'.branch_id ,
                branchs.name_'.$params['lang'].' as branch_name ,'.
                self::$main_table.'.finance_year_id ,
                finance_years.name as finance_year_name ,'.
                self::$main_table.'.stock_transaction_type_id ,
                stock_transaction_types.stock_transaction_type_title_'.$params['lang'].' as stock_transaction_type_title ,
                stock_transaction_status ,
                stock_transaction_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        if(isset($params['active']))
            $query->where('stock_transaction_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('stock_transaction_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('users.username', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_stock_transaction_m($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('stock_transaction_types' , self::$main_table.'.stock_transaction_type_id' , '=' , 'stock_transaction_types.stock_transaction_type_id')
            ->leftjoin('finance_years' , self::$main_table.'.finance_year_id' , '=' , 'finance_years.finance_year_id')
            ->leftjoin('branchs' , self::$main_table.'.branch_id' , '=' , 'branchs.branch_id')
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->where('stock_transaction_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stock_transaction_m_id as m_id ,'.
                self::$main_table.'.stock_transaction_type_id ,
                stock_transaction_date ,
                stock_transaction_description ,
                warehouse_id ,'.
                self::$main_table.'.branch_id ,
                branchs.name_'.$lang.' as branch_name ,'.
                self::$main_table.'.finance_year_id ,
                finance_years.name as finance_year_name ,'.
                self::$main_table.'.stock_transaction_type_id ,
                stock_transaction_types.stock_transaction_type_title_'.$lang.' as stock_transaction_type_title ,
                stock_transaction_status ,
                stock_transaction_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_stock_transaction_d($id , $lang = null)
    {
        $query = DB::table('stock_transaction_d')
            ->where('stock_transaction_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stock_transaction_m_id as m_id ,
                stock_transaction_d_id as d_id ,
                item_id ,
                unit_id ,
                quantity ,
                price ,
                total_price ,
                add_date ,
                add_user
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_stock_transaction_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_stock_transaction_d($seed)
    {
        return DB::table('stock_transaction_d')->insertGetId($seed);
    }

    public static function update_stock_transaction_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('stock_transaction_m_id', $id)->update($seed);
    }

    public static function delete_stock_transaction_m($id)
    {
        return DB::table(self::$main_table)->where('stock_transaction_m_id', $id)->update(array('stock_transaction_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_stock_transaction_d($id)
    {
        return DB::table('stock_transaction_d')->where('stock_transaction_m_id', $id)->delete();
    }
}
