<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use DB;

class StockTransfer extends Model
{
    protected $primaryKey     = 'stock_transfer_m_id';
    public static $main_table = 'stock_transfer_m';
    public $table             = 'stock_transfer_m';

    public static $master_rules = array(
        'stock_transfer_date'        => 'required|date',
        'stock_transfer_description' => 'required',
        'branch_id'                  => 'required|numeric',
        'finance_year_id'            => 'required|numeric',
        'year_ser'                   => 'required|numeric',
        'month_ser'                  => 'required|numeric',
        'branch_ser'                 => 'required|numeric',
    );

    public static $details_rules = array(
        'from_warehouse_id' => 'required|numeric',
        'to_warehouse_id'   => 'required|numeric',
        'item_id'           => 'required|numeric',
        'unit_id'           => 'required|numeric',
        'quantity'          => 'required|numeric',
        'price'             => 'required',
    );

    public static function all_stock_transfers($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->orderBy(self::$main_table.'.stock_transfer_m_id' , 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                stock_transfer_m_id as m_id ,
                stock_transfer_date ,
                stock_transfer_description ,
                branch_id ,
                finance_year_id ,
                stock_transfer_status ,
                stock_transfer_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        if(isset($params['active']))
            $query->where('stock_transfer_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('stock_transfer_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('users.username', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_stock_transfer_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->where('stock_transfer_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
                stock_transfer_m_id as m_id ,
                stock_transfer_date ,
                stock_transfer_description ,
                branch_id ,
                finance_year_id ,
                stock_transfer_status ,
                stock_transfer_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,'.
                self::$main_table.'.total_price ,
                users.username as added_by
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_stock_transfer_d($id, $lang = null)
    {
        $query = DB::table('stock_transfer_d')
            ->where('stock_transfer_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stock_transfer_m_id as m_id ,
                stock_transfer_d_id as d_id ,
                from_warehouse_id ,
                to_warehouse_id ,
                item_id ,
                unit_id ,
                quantity ,
                price ,
                total_price ,
                add_date ,
                add_user
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_stock_transfer_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_stock_transfer_d($seed)
    {
        return DB::table('stock_transfer_d')->insertGetId($seed);
    }

    public static function update_stock_transfer_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('stock_transfer_m_id', $id)->update($seed);
    }

    public static function delete_stock_transfer_m($id)
    {
        return DB::table(self::$main_table)->where('stock_transfer_m_id', $id)->update(array('stock_transfer_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_stock_transfer_d($id)
    {
        return DB::table('stock_transfer_d')->where('stock_transfer_m_id', $id)->delete();
    }
}
