<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class WarehouseTransaction extends Model
{
    protected $primaryKey     = 'warehouse_trans_m_id';
    public static $main_table = 'warehouse_trans_m';
    public $table             = 'warehouse_trans_m';

    public static $rules = array(
        'contract_id' => 'required',
        'action_date' => 'required|date',
        'type_id'     => 'required|exists:warehouse_trans_types,id',
    );

    public static function all_warehouse_trans($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_quotations','elevators_quotations.invoice_code' , 'warehouse_trans_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('warehouse_trans_d', 'warehouse_trans_d.warehouse_trans_m_id','warehouse_trans_m.warehouse_trans_m_id')
            ->leftJoin('warehouse_trans_types', 'warehouse_trans_types.id','warehouse_trans_m.type_id')
            ->orderBy(self::$main_table.'.warehouse_trans_m_id' , 'DESC')
            ->groupBy(self::$main_table.'.warehouse_trans_m_id');

        if(isset($params['lang']))
            $query->selectRaw('
                warehouse_trans_m.warehouse_trans_m_id ,
                warehouse_trans_m.contract_id ,
                elevators_quotations.invoice_code as contract_number ,
                warehouse_trans_m.action_date ,
                warehouse_trans_m.type_id ,
                warehouse_trans_types.name_'.$params['lang'].' as type_name,
                elevators_quotations.customer_id,
                customers.name_'.$params['lang'].' as customer_name,
                customers.phone ,
                warehouse_trans_m.description,
                SUM(warehouse_trans_d.amount) as amount ,
                warehouse_trans_m.active ,
                warehouse_trans_m.add_date ,
                warehouse_trans_m.add_user
            ');
        if(isset($params['customer_id'])){
            $query->where('customers.customer_id', $params['customer_id']);
        }
        if(isset($params['contract_number'])){
            $query->where('elevators_quotations.invoice_code', $params['contract_number']);
        }
        if(isset($params['from_date'])){
            $query->where('warehouse_trans_m.action_date', '>=', $params['from_date']);
        }

        if(isset($params['to_date'])){
            $query->where('warehouse_trans_m.action_date', '<=', $params['to_date']);
        }
        if(isset($params['active']))
            $query->where('warehouse_trans_m.active', $params['active']);


        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('elevators_quotations.invoice_code' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('warehouse_trans_m.description' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.phone' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_warehouse_trans_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_quotations','elevators_quotations.invoice_code' , 'warehouse_trans_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('warehouse_trans_types', 'warehouse_trans_types.id','warehouse_trans_m.type_id')

            ->where('warehouse_trans_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                warehouse_trans_m.warehouse_trans_m_id ,
                warehouse_trans_m.contract_id ,
                elevators_quotations.invoice_code as contract_number ,
                warehouse_trans_m.action_date ,
                warehouse_trans_m.type_id ,
                warehouse_trans_types.name_'.$lang.' as type_name,
                customers.name_'.$lang.' as customer_name,
                customers.phone ,
                warehouse_trans_m.description,
                warehouse_trans_m.active ,
                warehouse_trans_m.add_date ,
                warehouse_trans_m.add_user
            ');

        $data = $query->first();
        return $data;
    }

    public static function get_warehouse_trans_d($id, $lang = null)
    {
        $query = DB::table('warehouse_trans_d')
            ->leftJoin('warehouses', 'warehouses.warehouse_id','warehouse_trans_d.warehouse_id')
            ->leftJoin('unit_measurements', 'unit_measurements.unit_measurement_id','warehouse_trans_d.unit_id')
            ->leftJoin('items', 'items.item_id','warehouse_trans_d.item_id')
            ->where('warehouse_trans_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                warehouse_trans_d.warehouse_trans_d_id as d_id ,
                warehouse_trans_d.warehouse_trans_m_id as m_id,
                warehouse_trans_d.amount ,
                warehouse_trans_d.item_id ,
                items.name_'.$lang.' as item_name ,
                warehouse_trans_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                warehouse_trans_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                warehouse_trans_d.quantity
            ');

        $data = $query->get();
        return $data;
    }
    public static function get_attachments($id, $lang = null)
    {
        $query = DB::table('warehouse_trans_attachments')
            ->where('warehouse_trans_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                *
            ');

        $data = $query->get();
        return $data;
    }
    public static function get_types($lang = null)
    {
        $query = DB::table('warehouse_trans_types');

        if($lang != null)
            $query->selectRaw('
                id,
                name_'.$lang.' as name,
                type
            ');

        $data = $query->get();
        return $data;
    }
    public static function delete_attachments($id, $lang = null)
    {
        return DB::table('warehouse_trans_attachments')->where('attachment_id', $id)->delete();
    }
    public static function add_warehouse_trans_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }
    public static function add_warehouse_trans_d($seed)
    {
        return DB::table('warehouse_trans_d')->insertGetId($seed);
    }
    public static function update_warehouse_trans($seed, $id)
    {

        return DB::table(self::$main_table)->where('warehouse_trans_m_id', $id)->update($seed);
    }

    public static function delete_warehouse_trans($id)
    {
        return DB::table(self::$main_table)->where('warehouse_trans_m_id', $id)->update( array('active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

}
