<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Input extends Model
{

    protected $primaryKey = 'input_id';
    public static $main_table = 'inputs';

    public static $rules = array(

    );

    public static function all_inputs($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('input_order')
            ->where('input_active' , 1);

        if( isset($params['lang']) )
            $query->selectRaw('input_id as id  , input_label_'.$params['lang'].' as label  , type , value , lookups_id , lookups , cols , offsets , spaces , divider , required , multi , disabled');

        if( isset($params['screen_id']) )
            $query->whereRaw("find_in_set(".$params['screen_id']." , screen_sub_ids)");

        if( isset($params['location']) )
            $query->where('location', $params['location']);

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('input_label_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('input_label_en' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_input($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('input_id' , $id);

        if($lang != null){
            $query->selectRaw('input_id as id , input_categorys.input_category_id as category_id , input_category_title_'.$lang.' as category_title, input_label_'.$lang.' as label  , type , value , lookups_id , cols , offsets , spaces , divider , required , multi , disabled');
        }

        $data = $query->first();

        return $data;
    }



    public static function get_main_input_by_code($code , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('input_code' , $code);

        if($lang != null){
            $query->selectRaw('input_id as id , input_categorys.input_category_id as category_id , input_category_title_'.$lang.' as category_title, input_label_'.$lang.' as label  , type , value , lookups_id , cols , required , multi , disabled');
        }

        $data = $query->first();

        return $data;
    }




    public static function add_input($seed)
    {
        // return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_input($value ,  $id)
    {
        return DB::table(self::$main_table)->where('input_id' , $id )->update( array('value' => $value ) );
    }

    public static function delete_input($id)
    {
        // return DB::table(self::$main_table)->where('input_id' , $id )->update( array('input_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }

    public static function get_gold_price($in_date)
    {
        return DB::table('gold_price')
            ->where('add_date' , '<=' , date("Y-m-d H:i:s" , strtotime($in_date)))
            ->orderBy('id' , 'desc')
            ->selectRaw('add_date , ounce_price , round(24_price , 4) as 24_price , round(22_price , 4) as 22_price , round(21_price , 4) as 21_price , round(18_price , 4) as 18_price , round(24_price , 4) as price_24 , round(22_price , 4) as price_22 , round(21_price , 4) as price_21 , round(18_price , 4) as price_18 , ounce_price_sar as ounce')
            ->first();
    }


}
