<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Locations extends Model
{
    protected $primaryKey = 'id';

    public static $main_table = 'locations';

    public static $rules = array(
        'name_en'           => 'required|string|unique:locations' ,
        'name_ar'           => 'required|string|unique:locations' ,
    );



    public static function get_all($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('id');

        if( isset($params['lang']) )
            $query->selectRaw('id , name_'.$params['lang'].' as name  , add_date , add_user , active');

        if(isset($params['active']))
            $query->where('active' , $params['active'] );

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });

        }
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_one($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('id' , $id);

        if($lang != null){
            $query->selectRaw('id , name_'.$lang.' as name , add_date , add_user , active');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_location($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_location($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->update($seed);
    }

    public static function delete_location($id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
