<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class MainSetting extends Model
{

    protected $primaryKey = 'id';

    public static $main_table = 'main_setting';

    public static function active_main_setting($lang = null )
    {
        $query = DB::table(self::$main_table)
        ->where('super' , 0);

        if($lang != null){
            $query->selectRaw('id ,code , value , code_type as type');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_main_setting($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('super' , 0)
            ->where('id' , $id) ;

        if($lang != null){
            $query->selectRaw('id ,code , value , code_type as type');
        }
            
        $data = $query->first();
        return $data;
    }

    public static function get_main_setting_by_code($id)
    {
        $query = DB::table(self::$main_table)
            ->where('code' , $id) ;

            
        $data = $query->first();
        return $data;
    }


    public static function get_gold_price($in_date)
    {
        return DB::table('gold_price')
            ->where('add_date' , '<=' , date("Y-m-d H:i:s" , strtotime($in_date)))
            ->orderBy('id' , 'desc')
            ->selectRaw('add_date , round(24_price , 4) as 24_price , round(22_price , 4) as 22_price , round(21_price , 4) as 21_price , round(18_price , 4) as 18_price , round(24_price , 4) as price_24 , round(22_price , 4) as price_22 , round(21_price , 4) as price_21 , round(18_price , 4) as price_18 , ounce_price_sar as ounce')
            ->first();
    }



    public static function update_main_setting($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->update($seed);
    }


}
