<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Partner extends Model
{

    protected $primaryKey = 'partner_id';
    public static $main_table = 'partners';

    public static $rules = array(
        'name_en' => 'required|string|min:3',
        'name_ar' => 'required|string|min:3',
    );

    public static function all_partners($params = null)
    {
        $query = DB::table(self::$main_table);

        if(isset($params['lang'])){
            $query->selectRaw('partner_id as id , name_'.$params['lang'].' as name , account_tree_id , add_date');
        }


        if(isset($params['active']))
            $query->where('partner_active' , $params['active'] );


        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_partner($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('partner_id' , $id);

        if($lang != null){
            $query->selectRaw('partner_id as id , name_'.$lang.' as name , account_tree_id , add_date');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_partner($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_partner($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('partner_id' , $id )->update($seed);
    }

    public static function delete_partner($id)
    {
        return DB::table(self::$main_table)->where('partner_id' , $id )->update( array('partner_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}
