<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Platforms extends Model
{

    protected $primaryKey = 'platform_id';

    public static $main_table = 'platforms';

    public static $rules = array(

    );

    public static function all_platforms($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('platform_id');

        if( isset($params['lang']) )
            $query->selectRaw('platform_id as id ,
             name_'.$params['lang'].' as name ');

        $data = $query->get();

        return $data;
    }

    public static function get_platform($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('platform_id' , $id);

        if($lang != null){
            $query->selectRaw('
                platform_id as id ,
                name_'.$lang.' as name ,
            ');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_platform($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_platform($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('platform_id' , $id )->update($seed);
    }

    public static function delete_platform($id)
    {
        return DB::table(self::$main_table)->where('platform_id' , $id )->update( array('active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
