<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class SalesAgent extends Model
{

    protected $primaryKey = 'sales_agent_id';
    public static $main_table = 'sales_agents';

    public static $rules = array(
        'name_en'           => 'required|string' ,
        'name_ar'           => 'required|string' ,
        'account_tree_id'   => 'required|numeric' 
    );


    public static function all_sales_agents($params = null)
    {
        $query = DB::table(self::$main_table);

        if(isset($params['lang'])){
            $query->selectRaw('sales_agent_id as id , name_'.$params['lang'].' as name  , add_date');
        }


        if(isset($params['active']))
            $query->where('sales_agent_active' , $params['active'] );

        if( isset($params['branch']) ){
            $query->where(function($query2) use ($params) {
                $query2->whereRaw("find_in_set(".$params['branch']." , branch_id)");
                $query2->orWhereRaw("find_in_set(0 , branch_id)");
            });
        }
        
        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('sales_agent_id'  , $params['word']);
            });
            
        }

        if(isset($params['id']) && strlen($params['id']) >  0){
            $query->where('sales_agent_id' , $params['id'] );
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_sales_agent($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('sales_agent_id' , $id);

        if($lang != null){
            $query->selectRaw('sales_agent_id as id , name_'.$lang.' as name  , add_date');
        }
            
        $data = $query->first();
        return $data;
    }

    public static function add_sales_agent($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_sales_agent($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('sales_agent_id' , $id )->update($seed);
    }

    public static function delete_sales_agent($id)
    {
        return DB::table(self::$main_table)->where('sales_agent_id' , $id )->update( array('sales_agent_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}