<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class ScreenCat extends Model
{

    protected $primaryKey = 'screen_cat_id';

    public static $main_table = 'screen_cats';


    public static $rules = array(
        'screen_cat_title_en' => 'required|string|min:3',
        'screen_cat_title_ar' => 'required|string|min:3',
        'screen_main_id'      => 'required|numeric'
    );

    public static function all_screen_cats($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->join('screen_mains' , self::$main_table.'.screen_main_id' , '=' , 'screen_mains.screen_main_id')
            ->orderBy('screen_cat_order');

        if(isset($params['lang'])){
            $query->selectRaw(
                self::$main_table.'.screen_cat_id as id ,  
                screen_cat_title_'.$params['lang'].' as title ,
                screen_mains.screen_main_id as main_id , 
                screen_main_title_'.$params['lang'].' as main_title ,
                screen_main_image as main_image '
            );
        }

        if(isset($params['main']))
            $query->where( self::$main_table.'.screen_main_id' , $params['main'] );

        if(isset($params['active']))
            $query->where('screen_cat_active' , $params['active'] );
        
        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('screen_main_title_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_main_title_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_cat_title_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('screen_cat_title_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }
    
    public static function get_screen_cat($id)
    {
        return DB::table(self::$main_table)
            ->join('screen_mains' , self::$main_table.'.screen_main_id' , '=' , 'screen_mains.screen_main_id')
            ->where('screen_cat_id' , $id) 
            ->first();
    }

    public static function add_screen_cat($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_screen_cat($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('screen_cat_id' , $id )->update($seed);
    }

    public static function delete_screen_cat($id)
    {
        return DB::table(self::$main_table)->where('screen_cat_id' , $id )->update( array('screen_cat_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }
}
